/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import bolts.CancellationTokenSource;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpMetric;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.http.StreamingRequestBody;
import com.tencent.qcloud.core.task.QCloudTask;
import com.tencent.qcloud.core.task.TaskExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;

public final class HttpTask<T>
extends QCloudTask<HttpResult<T>> {
    private static AtomicInteger increments = new AtomicInteger(1);
    private final HttpRequest<T> httpRequest;
    private final QCloudCredentialProvider credentialProvider;
    private final QCloudHttpClient httpClient;
    private Call httpCall;
    private HttpResponse<T> httpResponse;
    private HttpResult<T> httpResult;
    private HttpMetric httpMetric;
    private QCloudProgressListener mProgressListener = new QCloudProgressListener(){

        @Override
        public void onProgress(long complete, long target) {
            HttpTask.this.onProgress(complete, target);
        }
    };

    HttpTask(HttpRequest<T> httpRequest, QCloudCredentialProvider credentialProvider, QCloudHttpClient httpClient) {
        super("HttpTask-" + httpRequest.tag() + "-" + increments.getAndIncrement(), httpRequest.tag());
        this.httpRequest = httpRequest;
        this.httpClient = httpClient;
        this.credentialProvider = credentialProvider;
    }

    public HttpTask<T> schedule() {
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            this.scheduleOn(TaskExecutors.UPLOAD_EXECUTOR, new CancellationTokenSource());
        } else if (this.httpRequest.getResponseBodyConverter() instanceof ProgressBody) {
            this.scheduleOn(TaskExecutors.DOWNLOAD_EXECUTOR, new CancellationTokenSource());
        } else {
            this.scheduleOn(TaskExecutors.COMMAND_EXECUTOR, new CancellationTokenSource());
        }
        return this;
    }

    public boolean isSuccessful() {
        return this.httpResult != null && this.httpResult.isSuccessful();
    }

    @Override
    public HttpResult<T> getResult() {
        return this.httpResult;
    }

    public HttpTask<T> attachMetric(HttpMetric httpMetric) {
        this.httpMetric = httpMetric;
        return this;
    }

    boolean isUploadTask() {
        if (this.httpRequest.getRequestBody() instanceof StreamingRequestBody) {
            return ((StreamingRequestBody)this.httpRequest.getRequestBody()).isLargeData();
        }
        return false;
    }

    boolean isDownloadTask() {
        return this.httpRequest.getResponseBodyConverter() instanceof ProgressBody;
    }

    double getAverageStreamingSpeed(long networkMillsTook) {
        ProgressBody body = null;
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            body = (ProgressBody)this.httpRequest.getRequestBody();
        } else if (this.httpRequest.getResponseBodyConverter() instanceof ProgressBody) {
            body = (ProgressBody)((Object)this.httpRequest.getResponseBodyConverter());
        }
        if (body != null) {
            return (double)body.getBytesTransferred() / 1024.0 / ((double)networkMillsTook / 1000.0);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResult<T> execute() throws QCloudClientException, QCloudServiceException {
        QCloudSigner signer;
        if (this.httpMetric != null) {
            this.httpMetric.start();
        }
        if (this.httpRequest.shouldCalculateContentMD5()) {
            this.calculateContentMD5();
        }
        if ((signer = this.httpRequest.getQCloudSigner()) != null) {
            this.signRequest(signer, this.httpRequest);
        }
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            ((ProgressBody)this.httpRequest.getRequestBody()).setProgressListener(this.mProgressListener);
        }
        QCloudClientException clientException = null;
        QCloudServiceException serviceException = null;
        Response response = null;
        try {
            this.httpRequest.setOkHttpRequestTag(this.getIdentifier());
            Request okHttpRequest = this.httpRequest.buildRealRequest();
            this.httpCall = this.httpClient.getOkHttpCall(okHttpRequest);
            if (this.httpMetric != null) {
                this.httpMetric.setRequestUrl(okHttpRequest.url().toString());
                this.httpMetric.setRequestMethod(okHttpRequest.method());
                RequestBody requestBody = okHttpRequest.body();
                if (requestBody != null) {
                    this.httpMetric.setRequestPayloadSize(requestBody.contentLength());
                    MediaType mediaType = requestBody.contentType();
                    if (mediaType != null) {
                        this.httpMetric.setRequestContentType(mediaType.type());
                    }
                }
            }
            if ((response = this.httpCall.execute()) != null) {
                if (this.httpResult == null) {
                    this.convertResponse(response);
                }
            } else {
                serviceException = new QCloudServiceException("http response is null");
            }
            Util.closeQuietly((Closeable)response);
        }
        catch (IOException e) {
            if (e.getCause() instanceof QCloudClientException) {
                clientException = (QCloudClientException)e.getCause();
            } else if (e.getCause() instanceof QCloudServiceException) {
                serviceException = (QCloudServiceException)e.getCause();
            } else {
                clientException = new QCloudClientException(e);
            }
        }
        finally {
            Util.closeQuietly(response);
        }
        if (this.httpMetric != null) {
            this.httpMetric.stop();
        }
        if (clientException != null) {
            if (this.httpMetric != null) {
                this.httpMetric.traceException(clientException);
            }
            throw clientException;
        }
        if (serviceException != null) {
            if (this.httpMetric != null) {
                this.httpMetric.traceException(serviceException);
            }
            throw serviceException;
        }
        return this.httpResult;
    }

    @Override
    public void cancel() {
        if (this.httpCall != null) {
            this.httpCall.cancel();
        }
        super.cancel();
    }

    private void signRequest(QCloudSigner signer, HttpRequest request) throws QCloudClientException {
        if (this.credentialProvider == null) {
            throw new QCloudClientException("no credentials provider");
        }
        QCloudCredentials credentials = this.credentialProvider.getCredentials();
        signer.sign((QCloudHttpRequest)request, credentials);
    }

    private void calculateContentMD5() throws QCloudClientException {
        RequestBody requestBody = this.httpRequest.getRequestBody();
        if (requestBody == null) {
            throw new QCloudClientException("get md5 canceled, request body is null.");
        }
        Buffer sink = new Buffer();
        try {
            requestBody.writeTo((BufferedSink)sink);
        }
        catch (IOException e) {
            throw new QCloudClientException("calculate md5 error", e);
        }
        String md5 = sink.md5().base64();
        this.httpRequest.addHeader("Content-MD5", md5);
        sink.close();
    }

    void convertResponse(Response response) throws QCloudClientException, QCloudServiceException {
        if (this.httpMetric != null) {
            this.httpMetric.setStatusCode(response.code());
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                this.httpMetric.setResponsePayloadSize(responseBody.contentLength());
                MediaType mediaType = responseBody.contentType();
                if (mediaType != null) {
                    this.httpMetric.setResponseContentType(mediaType.type());
                }
            }
        }
        this.httpResponse = new HttpResponse<T>(this.httpRequest, response);
        ResponseBodyConverter<T> converter = this.httpRequest.getResponseBodyConverter();
        if (converter instanceof ProgressBody) {
            ((ProgressBody)((Object)converter)).setProgressListener(this.mProgressListener);
        }
        T content = converter.convert(this.httpResponse);
        this.httpResult = new HttpResult<T>(this.httpResponse, content);
    }
}

