/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.AuthConstants;
import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.QCloudHttpRequest;

public class COSXmlSigner
implements QCloudSigner {
    private static final String COS_SESSION_TOKEN = "x-cos-security-token";

    @Override
    public void sign(QCloudHttpRequest request, QCloudCredentials credentials) throws QCloudClientException {
        if (credentials == null) {
            throw new QCloudClientException("Credentials is null.");
        }
        COSXmlSignSourceProvider sourceProvider = (COSXmlSignSourceProvider)request.getSignProvider();
        if (sourceProvider == null) {
            throw new QCloudClientException("No sign provider for cos xml signer.");
        }
        StringBuilder authorization = new StringBuilder();
        QCloudLifecycleCredentials lifecycleCredentials = (QCloudLifecycleCredentials)credentials;
        String signature = this.signature(sourceProvider.source(request), lifecycleCredentials.getSignKey());
        authorization.append(AuthConstants.Q_SIGN_ALGORITHM).append("=").append(AuthConstants.SHA1).append("&").append(AuthConstants.Q_AK).append("=").append(credentials.getSecretId()).append("&").append(AuthConstants.Q_SIGN_TIME).append("=").append(sourceProvider.getSignTime()).append("&").append(AuthConstants.Q_KEY_TIME).append("=").append(lifecycleCredentials.getKeyTime()).append("&").append(AuthConstants.Q_HEADER_LIST).append("=").append(sourceProvider.getRealHeaderList().toLowerCase()).append("&").append(AuthConstants.Q_URL_PARAM_LIST).append("=").append(sourceProvider.getRealParameterList().toLowerCase()).append("&").append(AuthConstants.Q_SIGNATURE).append("=").append(signature);
        request.addHeader("Authorization", authorization.toString());
        if (credentials instanceof SessionQCloudCredentials) {
            SessionQCloudCredentials sessionCredentials = (SessionQCloudCredentials)credentials;
            request.addHeader(COS_SESSION_TOKEN, sessionCredentials.getToken());
        }
    }

    private String signature(String source, String signKey) throws QCloudClientException {
        byte[] sha1Bytes = Utils.hmacSha1(source, signKey);
        String signature = "";
        if (sha1Bytes != null) {
            signature = new String(Utils.encodeHex(sha1Bytes));
        }
        return signature;
    }
}

