/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import com.tencent.qcloud.core.util.ContextHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class QCloudUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUriContentLength(Uri uri, ContentResolver contentResolver) {
        String scheme = uri.getScheme();
        if ("content".equals(scheme)) {
            Cursor cursor = contentResolver.query(uri, null, null, null, null);
            if (cursor != null) {
                try {
                    int sizeIndex = cursor.getColumnIndex("_size");
                    if (cursor.moveToFirst()) {
                        long l = cursor.getLong(sizeIndex);
                        return l;
                    }
                    long l = -1L;
                    return l;
                }
                finally {
                    cursor.close();
                }
            }
        } else if ("file".equals(scheme)) {
            File file = new File(uri.getPath());
            return file.length();
        }
        return -1L;
    }

    public static byte[] toBytes(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    public static Object toObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String fileName, byte[] bytes) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(fileName);
            fileOutputStream.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static byte[] readBytesFromFile(String fileName) {
        FileInputStream fileInputStream = null;
        byte[] data = null;
        try {
            File file = new File(fileName);
            data = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    public static boolean isNetworkConnected() {
        Context context = ContextHolder.getAppContext();
        if (context == null) {
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return true;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }
}

