/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.core.http.DnsRepository;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.List;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;

public class OkHttpProxy<T>
extends NetworkProxy<T> {
    private Call httpCall;
    private Field eventListenerFiled;
    private OkHttpClient okHttpClient;

    public OkHttpProxy(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void cancel() {
        if (this.httpCall != null) {
            this.httpCall.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected HttpResult<T> executeHttpRequest(HttpRequest<T> httpRequest) throws QCloudClientException, QCloudServiceException {
        HttpResult<T> httpResult;
        CallMetricsListener eventListener;
        Response response;
        QCloudServiceException serviceException;
        QCloudClientException clientException;
        block19: {
            clientException = null;
            serviceException = null;
            response = null;
            eventListener = null;
            httpResult = null;
            try {
                httpRequest.setOkHttpRequestTag(this.identifier);
                Request okHttpRequest = httpRequest.buildRealRequest();
                this.httpCall = this.okHttpClient.newCall(okHttpRequest);
                if (this.eventListenerFiled == null) {
                    try {
                        this.eventListenerFiled = this.httpCall.getClass().getDeclaredField("eventListener");
                        this.eventListenerFiled.setAccessible(true);
                        eventListener = (CallMetricsListener)((Object)this.eventListenerFiled.get(this.httpCall));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if ((response = this.httpCall.execute()) != null) {
                    if (httpResult == null) {
                        httpResult = this.convertResponse(httpRequest, response);
                    }
                } else {
                    serviceException = new QCloudServiceException("http response is null");
                }
                if (response == null) break block19;
            }
            catch (IOException e) {
                if (e.getCause() instanceof QCloudClientException) {
                    clientException = (QCloudClientException)e.getCause();
                    break block19;
                }
                if (e.getCause() instanceof QCloudServiceException) {
                    serviceException = (QCloudServiceException)e.getCause();
                    break block19;
                } else {
                    clientException = new QCloudClientException(e);
                }
                break block19;
            }
            Util.closeQuietly((Closeable)response);
            break block19;
            finally {
                if (response != null) {
                    Util.closeQuietly(response);
                }
            }
        }
        if (eventListener != null) {
            eventListener.dumpMetrics(this.metrics);
        }
        if (clientException != null) {
            throw clientException;
        }
        if (serviceException != null) {
            throw serviceException;
        }
        if (!this.isCosResponse(response)) return httpResult;
        this.recordDns(httpRequest.host(), eventListener);
        return httpResult;
    }

    private void recordDns(String host, CallMetricsListener eventListener) {
        List<InetAddress> dnsRecord = null;
        if (eventListener != null && (dnsRecord = eventListener.dumpDns()) != null) {
            DnsRepository.getInstance().insertDnsRecordCache(host, dnsRecord);
        }
    }

    private boolean isCosResponse(Response response) {
        return response != null && "tencent-cos".equalsIgnoreCase(response.header("Server"));
    }

    @Override
    protected HttpResult<T> convertResponse(HttpRequest<T> request, Response response) throws QCloudClientException, QCloudServiceException {
        HttpResponse<T> httpResponse = new HttpResponse<T>(request, response);
        ResponseBodyConverter<T> converter = request.getResponseBodyConverter();
        if (converter instanceof ProgressBody) {
            ((ProgressBody)((Object)converter)).setProgressListener(this.mProgressListener);
        }
        T content = converter.convert(httpResponse);
        return new HttpResult<T>(httpResponse, content);
    }
}

