/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.http.OkHttpLoggingUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.platform.Platform;

public final class HttpLoggingInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Logger logger;
    private volatile Level level = Level.NONE;

    public HttpLoggingInterceptor() {
        this(Logger.DEFAULT);
    }

    public HttpLoggingInterceptor(Logger logger) {
        this.logger = logger;
    }

    public HttpLoggingInterceptor setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level == null. Use Level.NONE instead.");
        }
        this.level = level;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Level level = this.level;
        Request request = chain.request();
        if (level == Level.NONE) {
            return chain.proceed(request);
        }
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        OkHttpLoggingUtils.logRequest(request, protocol, level, this.logger);
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.logException(e, "<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        OkHttpLoggingUtils.logResponse(response, tookMs, level, this.logger);
        return response;
    }

    public static interface Logger {
        public static final Logger DEFAULT = new Logger(){

            @Override
            public void logRequest(String message) {
                Platform.get().log(4, message, null);
            }

            @Override
            public void logResponse(Response response, String message) {
                Platform.get().log(4, message, null);
            }

            @Override
            public void logException(Exception exception, String message) {
                Platform.get().log(4, message, null);
            }
        };

        public void logRequest(String var1);

        public void logResponse(Response var1, String var2);

        public void logException(Exception var1, String var2);
    }

    public static enum Level {
        NONE,
        BASIC,
        HEADERS,
        BODY;

    }
}

