/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.STSCredentialScope;
import com.tencent.qcloud.core.auth.ScopeLimitCredentialProvider;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class BasicScopeLimitCredentialProvider
implements ScopeLimitCredentialProvider {
    private static final int MAX_CACHE_CREDENTIAL_SIZE = 100;
    private Map<Integer, SessionQCloudCredentials> credentialPairs = new HashMap<Integer, SessionQCloudCredentials>(100);

    @Override
    public SessionQCloudCredentials getCredentials(STSCredentialScope[] credentialScope) throws QCloudClientException {
        int scopeId = STSCredentialScope.jsonify(credentialScope).hashCode();
        SessionQCloudCredentials credentials = this.lookupValidCredentials(scopeId);
        if (credentials == null) {
            credentials = this.fetchNewCredentials(credentialScope);
            this.cacheCredentialsAndCleanUp(scopeId, credentials);
        }
        return credentials;
    }

    private synchronized SessionQCloudCredentials lookupValidCredentials(int scopeId) {
        SessionQCloudCredentials credentials = this.credentialPairs.get(scopeId);
        if (credentials != null && credentials.isValid()) {
            return credentials;
        }
        return null;
    }

    private synchronized void cacheCredentialsAndCleanUp(int scopeId, SessionQCloudCredentials newCredentials) {
        Iterator<Map.Entry<Integer, SessionQCloudCredentials>> it = this.credentialPairs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, SessionQCloudCredentials> entry = it.next();
            if (entry.getValue().isValid()) continue;
            it.remove();
        }
        if (this.credentialPairs.size() > 100) {
            int overSize = this.credentialPairs.size() - 100;
            Iterator<Map.Entry<Integer, SessionQCloudCredentials>> it2 = this.credentialPairs.entrySet().iterator();
            while (it2.hasNext() && overSize-- > 0) {
                it2.remove();
            }
        }
        this.credentialPairs.put(scopeId, newCredentials);
    }

    @Override
    public void refresh() {
    }

    @Override
    public QCloudCredentials getCredentials() throws QCloudClientException {
        throw new UnsupportedOperationException("not support ths op");
    }

    protected abstract SessionQCloudCredentials fetchNewCredentials(STSCredentialScope[] var1) throws QCloudClientException;
}

