/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tencent.qcloud.core.logger.FileLogItem;
import com.tencent.qcloud.core.logger.LogAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class FileLogAdapter
implements LogAdapter {
    private String alias;
    private int minPriority;
    private static final String LOG_DIR = "QCloudLogs";
    private static final int MAX_FILE_SIZE = 0x300000;
    private static final long LOG_FLUSH_DURATION = 10000L;
    private static final long BUFFER_SIZE = 32768L;
    private static final int MAX_FILE_COUNT = 30;
    private File logRootDir;
    private File latestLogFile;
    private static final int MSG_FLUSH_ALL = 0;
    private static final int MSG_FLUSH_CONTENT = 1;
    private Handler handler;
    private List<FileLogItem> bufferRecord = Collections.synchronizedList(new ArrayList());
    private volatile long mBufferSize = 0L;
    private static final byte[] object = new byte[0];
    private static FileLogAdapter instance;

    public static FileLogAdapter getInstance(Context context, String alias) {
        return FileLogAdapter.getInstance(context, alias, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileLogAdapter getInstance(Context context, String alias, int minPriority) {
        Class<FileLogAdapter> clazz = FileLogAdapter.class;
        synchronized (FileLogAdapter.class) {
            if (instance == null) {
                instance = new FileLogAdapter(context, alias, minPriority);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    private FileLogAdapter(Context context, String alias, int minPriority) {
        this.alias = alias;
        this.minPriority = minPriority;
        this.logRootDir = new File(context.getExternalCacheDir() + File.separator + LOG_DIR);
        HandlerThread handlerThread = new HandlerThread("log_handlerThread", 1);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        FileLogAdapter.this.flush();
                        this.sendEmptyMessageDelayed(0, 10000L);
                        break;
                    }
                    case 1: {
                        FileLogAdapter.this.input();
                    }
                }
            }
        };
        Message message = this.handler.obtainMessage();
        message.what = 0;
        this.handler.sendMessage(message);
    }

    @Override
    public boolean isLoggable(int priority, @Nullable String tag) {
        return priority >= this.minPriority;
    }

    @Override
    public synchronized void log(int priority, @NonNull String tag, @NonNull String message, @Nullable Throwable tr) {
        FileLogItem r = new FileLogItem(tag, priority, message, tr);
        this.bufferRecord.add(r);
        this.mBufferSize += r.getLength();
        this.handler.removeMessages(1);
        this.handler.sendEmptyMessageDelayed(1, 500L);
    }

    private String formatDateString(long times) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss", Locale.getDefault());
        return simpleDateFormat.format(times);
    }

    private boolean isSameDay(String timesString, long dateTime) {
        SimpleDateFormat fmt1 = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss", Locale.getDefault());
        SimpleDateFormat fmt2 = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        try {
            String string1 = fmt2.format(fmt1.parse(timesString));
            String string2 = fmt2.format(dateTime);
            return string1.equals(string2);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public File[] getLogFilesDesc(int limit) {
        if (this.logRootDir.listFiles() != null && this.logRootDir.listFiles().length > 0) {
            File[] logFiles = this.logRootDir.listFiles();
            Arrays.sort(logFiles, new Comparator<File>(){

                @Override
                public int compare(File lhs, File rhs) {
                    return Long.valueOf(rhs.lastModified()).compareTo(lhs.lastModified());
                }
            });
            File[] required = new File[Math.min(limit, logFiles.length)];
            System.arraycopy(logFiles, 0, required, 0, required.length);
            return required;
        }
        return null;
    }

    private File getLogFile(long times) {
        String fileLogDate;
        File[] logFiles = this.logRootDir.listFiles();
        if (this.latestLogFile == null) {
            if (!this.logRootDir.exists() && !this.logRootDir.mkdirs()) {
                return null;
            }
            if (logFiles != null && logFiles.length > 0) {
                Arrays.sort(logFiles, new Comparator<File>(){

                    @Override
                    public int compare(File lhs, File rhs) {
                        return Long.valueOf(rhs.lastModified()).compareTo(lhs.lastModified());
                    }
                });
                this.latestLogFile = logFiles[0];
            }
        }
        if (this.latestLogFile != null && this.latestLogFile.length() < 0x300000L && this.isSameDay(fileLogDate = this.latestLogFile.getName().replace(".log", ""), times)) {
            return this.latestLogFile;
        }
        this.latestLogFile = new File(this.logRootDir + File.separator + this.formatDateString(times) + ".log");
        this.cleanFilesIfNecessary(logFiles);
        return this.latestLogFile;
    }

    private void cleanFilesIfNecessary(File[] logFiles) {
        if (logFiles != null && logFiles.length >= 30) {
            logFiles[logFiles.length - 1].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(List<FileLogItem> listInfo) {
        byte[] byArray = object;
        synchronized (object) {
            if (listInfo == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FileOutputStream fos = null;
            try {
                File file = this.getLogFile(System.currentTimeMillis());
                if (file != null) {
                    fos = new FileOutputStream(file, true);
                    for (int i = 0; i < listInfo.size(); ++i) {
                        fos.write(listInfo.get(i).toString().getBytes("UTF-8"));
                    }
                    fos.flush();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private synchronized void flush() {
        if (this.mBufferSize <= 0L) {
            return;
        }
        this.write(this.bufferRecord);
        this.bufferRecord.clear();
        this.mBufferSize = 0L;
    }

    private synchronized void input() {
        if (this.mBufferSize > 32768L) {
            this.flush();
        }
    }
}

