/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CountingSink;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.Sink;

public class ResponseFileConverter<T>
extends ResponseBodyConverter<T>
implements ProgressBody {
    private String filePath;
    private long offset;
    protected boolean isQuic = false;
    protected QCloudProgressListener progressListener;
    private CountingSink countingSink;

    public ResponseFileConverter(String filePath, long offset) {
        this.filePath = filePath;
        this.offset = offset;
    }

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void enableQuic(boolean isQuic) {
        this.isQuic = isQuic;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public T convert(HttpResponse<T> response) throws QCloudClientException, QCloudServiceException {
        if (this.isQuic) {
            return null;
        }
        HttpResponse.checkResponseSuccessful(response);
        String contentRangeString = response.header("Content-Range");
        long[] contentRange = QCloudHttpUtils.parseContentRange(contentRangeString);
        long contentLength = contentRange != null ? contentRange[1] - contentRange[0] + 1L : response.contentLength();
        File downloadFilePath = new File(this.filePath);
        File parentDir = downloadFilePath.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new QCloudClientException("local file directory can not create.");
        }
        ResponseBody body = response.response.body();
        if (body == null) {
            throw new QCloudServiceException("response body is empty !");
        }
        try {
            this.writeRandomAccessFile(downloadFilePath, response.byteStream(), contentLength);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QCloudClientException("write local file error for " + e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRandomAccessFile(File downloadFilePath, InputStream inputStream, long contentLength) throws IOException, QCloudClientException {
        if (inputStream == null) {
            throw new QCloudClientException("response body stream is null");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            int len;
            randomAccessFile = new RandomAccessFile(downloadFilePath, "rws");
            if (this.offset > 0L) {
                randomAccessFile.seek(this.offset);
            }
            byte[] buffer = new byte[8192];
            this.countingSink = new CountingSink((Sink)new Buffer(), contentLength, this.progressListener);
            while ((len = inputStream.read(buffer)) != -1) {
                randomAccessFile.write(buffer, 0, len);
                this.countingSink.writeBytesInternal(len);
            }
        }
        catch (Throwable throwable) {
            Util.closeQuietly(randomAccessFile);
            throw throwable;
        }
        Util.closeQuietly((Closeable)randomAccessFile);
    }

    public OutputStream getOutputStream() throws QCloudClientException {
        File downloadFilePath = new File(this.filePath);
        File parentDir = downloadFilePath.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new QCloudClientException("local file directory can not create.");
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(downloadFilePath);
            return outputStream;
        }
        catch (FileNotFoundException e) {
            throw new QCloudClientException(e);
        }
    }

    @Override
    public long getBytesTransferred() {
        return this.countingSink != null ? this.countingSink.getTotalTransferred() : 0L;
    }
}

