/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.http.HttpLoggingInterceptor;
import com.tencent.qcloud.core.logger.FileLogAdapter;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

public class HttpLogger
implements HttpLoggingInterceptor.Logger {
    private boolean debuggable;
    private FileLogAdapter fileLogAdapter;
    private List<String> mRequestBufferLogs;

    HttpLogger(boolean debuggable) {
        this.debuggable = debuggable;
        this.mRequestBufferLogs = new ArrayList<String>(10);
    }

    public void setDebug(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Override
    public void logRequest(String message) {
        if (this.debuggable) {
            QCloudLogger.i("QCloudHttp", message, new Object[0]);
        }
        this.fileLogAdapter = QCloudLogger.getAdapter(FileLogAdapter.class);
        if (this.fileLogAdapter != null) {
            this.mRequestBufferLogs.add(message);
        }
    }

    @Override
    public void logResponse(Response response, String message) {
        if (this.debuggable) {
            QCloudLogger.i("QCloudHttp", message, new Object[0]);
        }
        if (this.fileLogAdapter != null && response != null && !response.isSuccessful()) {
            this.flushRequestBufferLogs();
            this.fileLogAdapter.log(4, "QCloudHttp", message, null);
        } else {
            this.mRequestBufferLogs.clear();
        }
    }

    @Override
    public void logException(Exception exception, String message) {
        QCloudLogger.i("QCloudHttp", message, new Object[0]);
        if (this.fileLogAdapter != null && exception != null) {
            this.flushRequestBufferLogs();
            this.fileLogAdapter.log(4, "QCloudHttp", message, exception);
        } else {
            this.mRequestBufferLogs.clear();
        }
    }

    private void flushRequestBufferLogs() {
        if (this.fileLogAdapter != null && this.mRequestBufferLogs.size() > 0) {
            for (String requestLog : this.mRequestBufferLogs) {
                this.fileLogAdapter.log(4, "QCloudHttp", requestLog, null);
            }
            this.mRequestBufferLogs.clear();
        }
    }
}

