/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.BasicScopeLimitCredentialProvider;
import com.tencent.qcloud.core.auth.STSCredentialScope;
import com.tencent.qcloud.core.auth.SessionCredentialProvider;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.RequestBodySerializer;

public class STSScopeLimitCredentialProvider
extends BasicScopeLimitCredentialProvider {
    private HttpRequest.Builder<String> requestBuilder;

    public STSScopeLimitCredentialProvider(HttpRequest.Builder<String> requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    @Override
    public SessionQCloudCredentials fetchNewCredentials(STSCredentialScope[] credentialScope) throws QCloudClientException {
        RequestBodySerializer serializer = RequestBodySerializer.string("application/json", STSCredentialScope.jsonify(credentialScope));
        this.requestBuilder.body(serializer).method("POST");
        HttpRequest<String> fetchSTSRequest = this.buildRequest(this.requestBuilder);
        try {
            HttpResult result = (HttpResult)QCloudHttpClient.getDefault().resolveRequest(fetchSTSRequest).executeNow();
            if (result.isSuccessful()) {
                return this.parseServerResponse((String)result.content());
            }
            throw new QCloudClientException("fetch new credentials error ", result.asException());
        }
        catch (QCloudServiceException e) {
            throw new QCloudClientException("fetch new credentials error ", e);
        }
    }

    protected HttpRequest<String> buildRequest(HttpRequest.Builder<String> requestBuilder) {
        return requestBuilder.build();
    }

    protected SessionQCloudCredentials parseServerResponse(String jsonContent) throws QCloudClientException {
        return SessionCredentialProvider.parseStandardSTSJsonResponse(jsonContent);
    }
}

