/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.Task;

public abstract class CancelableTask<T>
extends Task<T> {
    private boolean canceled;

    public CancelableTask(String identifier, Object tag) {
        super(identifier, tag);
    }

    @Override
    public void run() {
        if (this.isCanceled()) {
            return;
        }
        super.run();
    }

    @Override
    protected void onProgress(long complete, long target) {
        if (this.isCanceled()) {
            return;
        }
        super.onProgress(complete, target);
    }

    @Override
    protected void onSuccess() {
        if (this.isCanceled()) {
            return;
        }
        super.onSuccess();
    }

    @Override
    protected void onFailure() {
        if (this.isCanceled()) {
            return;
        }
        super.onFailure();
    }

    protected abstract boolean onCancel();

    public synchronized boolean isCanceled() {
        return this.canceled;
    }

    public final synchronized void cancel() {
        if (this.canceled || this.completed) {
            return;
        }
        if (this.onCancel()) {
            this.workerExecutor.remove(this);
            this.close();
            this.canceled = true;
            QCloudLogger.d("QCloudTask", "[Call] %s cancel", this);
        }
    }
}

