/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.tencent.qcloud.core.logger.Record;
import com.tencent.qcloud.core.logger.RecordLevel;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

class RecordLog {
    private String flag = null;
    public static final String LOG_DIR = "QCloudLogs";
    private static final int MAX_FILE_SIZE = 32768;
    private static final int MAX_FILE_COUNT = 30;
    private static final long LOG_FLUSH_DURATION = 10000L;
    private static final long BUFFER_SIZE = 32768L;
    private String logRootDir = null;
    private FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String filename = pathname.getName();
            boolean result = filename.endsWith("." + RecordLog.this.flag + ".log");
            if (!result) {
                return false;
            }
            result = RecordLog.this.getIndexFromFile(pathname) != -1;
            return result;
        }
    };
    private static final int MSG_FLUSH_ALL = 0;
    private static final int MSG_FLUSH_CONTENT = 1;
    private static final int MSG_DELETE_FILE = 2;
    private Handler handler = null;
    private List<Record> bufferRecord = Collections.synchronizedList(new ArrayList());
    private volatile long mBufferSize = 0L;
    private static final byte[] object = new byte[0];
    private static final byte[] instance = new byte[0];
    private static RecordLog recordLog = null;

    private RecordLog(Context context, String flag) {
        this.flag = flag;
        this.logRootDir = context.getExternalCacheDir() + File.separator + LOG_DIR;
        HandlerThread handlerThread = new HandlerThread("log_handlerThread", 1);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        RecordLog.this.flush();
                        this.sendEmptyMessageDelayed(0, 10000L);
                        break;
                    }
                    case 1: {
                        RecordLog.this.input();
                        break;
                    }
                }
            }
        };
        Message message = this.handler.obtainMessage();
        message.what = 0;
        this.handler.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordLog getInstance(Context context, String flag) {
        byte[] byArray = instance;
        synchronized (instance) {
            if (recordLog == null) {
                recordLog = new RecordLog(context, flag);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return recordLog;
        }
    }

    String getTodayDate() {
        String simple_date_formate = "yyyy-MM-dd";
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(simple_date_formate, Locale.getDefault());
        return simpleDateFormat.format(date);
    }

    String getLongDate(long times) {
        String simple_date_formate = "yyyy-MM-dd";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(simple_date_formate, Locale.getDefault());
        return simpleDateFormat.format(times);
    }

    File getLogFileDir() {
        String dir = this.logRootDir + File.separator + this.getTodayDate();
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    File getLogFile(long times) {
        String dirName = this.logRootDir + File.separator + this.getLongDate(times);
        File file = new File(dirName);
        if (!file.exists()) {
            file.mkdirs();
            return new File(dirName, "1." + this.flag + ".log");
        }
        File[] fileslist = file.listFiles(this.fileFilter);
        if (fileslist == null || fileslist.length == 0) {
            return new File(dirName, "1." + this.flag + ".log");
        }
        Arrays.sort(fileslist, new Comparator<File>(){

            @Override
            public int compare(File lhs, File rhs) {
                return RecordLog.this.getIndexFromFile(lhs) - RecordLog.this.getIndexFromFile(rhs);
            }
        });
        File last = fileslist[fileslist.length - 1];
        if (last.length() > 32768L) {
            int newIndex = this.getIndexFromFile(last) + 1;
            last = new File(dirName, "" + newIndex + "." + this.flag + ".log");
        }
        int filecounts = fileslist.length + 1;
        for (int i = 0; i < filecounts - 30; ++i) {
            fileslist[i].delete();
        }
        return last;
    }

    int getIndexFromFile(File file) {
        try {
            String filename = file.getName();
            int point = filename.indexOf(46);
            filename = filename.substring(0, point);
            return Integer.valueOf(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(List<Record> listInfo) {
        byte[] byArray = object;
        synchronized (object) {
            if (listInfo == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            FileOutputStream fos = null;
            try {
                File file = this.getLogFile(System.currentTimeMillis());
                fos = new FileOutputStream(file, true);
                for (int i = 0; i < listInfo.size(); ++i) {
                    fos.write(listInfo.get(i).toString().getBytes("UTF-8"));
                }
                fos.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized void appendRecord(String tag, RecordLevel level, String msg, Throwable t) {
        Record r = new Record(tag, level, msg, t);
        this.bufferRecord.add(r);
        this.mBufferSize += r.getLength();
        this.handler.removeMessages(1);
        this.handler.sendEmptyMessageDelayed(1, 500L);
    }

    synchronized void flush() {
        if (this.mBufferSize <= 0L) {
            return;
        }
        this.write(this.bufferRecord);
        this.bufferRecord.clear();
        this.mBufferSize = 0L;
    }

    synchronized void input() {
        if (this.mBufferSize > 32768L) {
            this.flush();
        }
    }
}

