/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.util.Log;
import com.tencent.qcloud.core.logger.RecordLevel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

class Record {
    private String tag = null;
    private String msg = null;
    private Throwable throwable = null;
    private RecordLevel level = null;
    private long timestamp;
    private long threadId;
    private String threadName = null;

    public Record(String tag, RecordLevel level, String msg, Throwable t) {
        this.level = level;
        this.tag = tag;
        this.msg = msg;
        this.throwable = t;
        this.timestamp = System.currentTimeMillis();
        this.threadId = Thread.currentThread().getId();
        this.threadName = Thread.currentThread().getName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.level).append("/");
        builder.append(Record.timeUtils(this.timestamp, "yyyy-MM-dd HH:mm:ss"));
        builder.append("[").append(this.threadName).append(" ").append(this.threadId).append("]");
        builder.append("[").append(this.tag).append("]");
        builder.append("[").append(this.msg).append("]");
        if (this.throwable != null) {
            builder.append(" * Exception :\n").append(Log.getStackTraceString((Throwable)this.throwable));
        }
        builder.append("\n");
        return builder.toString();
    }

    static String timeUtils(long seconds, String dateFormat) {
        Date dat = new Date(seconds);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dat);
        SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.CHINA);
        return format.format(gc.getTime());
    }

    public long getLength() {
        return (this.msg != null ? this.msg.length() : 0) + 40;
    }
}

