/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.qcloud.core.logger.RecordLevel;
import com.tencent.qcloud.core.logger.RecordLog;

public final class QCloudLogger {
    private static RecordLog recordLog;
    private static final int VERBOSE = 2;
    private static final int DEBUG = 3;
    private static final int INFO = 4;
    private static final int WARN = 5;
    private static final int ERROR = 6;

    public static void setUp(Context context) {
        if (context == null) {
            return;
        }
        recordLog = RecordLog.getInstance(context, "cloud");
    }

    private QCloudLogger() {
    }

    public static int v(String tag, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 2)) {
            try {
                return Log.v((String)tag, (String)(args.length > 0 ? String.format(format, args) : format));
            }
            catch (Exception e) {
                return Log.v((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int v(String tag, Throwable tr, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 2)) {
            try {
                return Log.v((String)tag, (String)(args.length > 0 ? String.format(format, args) : format), (Throwable)tr);
            }
            catch (Exception e) {
                return Log.v((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int d(String tag, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 3)) {
            try {
                return Log.d((String)tag, (String)(args.length > 0 ? String.format(format, args) : format));
            }
            catch (Exception e) {
                return Log.d((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int d(String tag, Throwable tr, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 3)) {
            try {
                return Log.d((String)tag, (String)(args.length > 0 ? String.format(format, args) : format), (Throwable)tr);
            }
            catch (Exception e) {
                return Log.d((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int i(String tag, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 4)) {
            try {
                String message = args.length > 0 ? String.format(format, args) : format;
                int r = Log.i((String)tag, (String)message);
                QCloudLogger.flush(tag, RecordLevel.INFO, message, null);
                return r;
            }
            catch (Exception e) {
                return Log.i((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int i(String tag, Throwable tr, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 4)) {
            try {
                String message = args.length > 0 ? String.format(format, args) : format;
                int r = Log.i((String)tag, (String)message, (Throwable)tr);
                QCloudLogger.flush(tag, RecordLevel.INFO, message, tr);
                return r;
            }
            catch (Exception e) {
                return Log.i((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int w(String tag, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 5)) {
            try {
                String message = args.length > 0 ? String.format(format, args) : format;
                int r = Log.w((String)tag, (String)message);
                QCloudLogger.flush(tag, RecordLevel.INFO, message, null);
                return r;
            }
            catch (Exception e) {
                return Log.w((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int w(String tag, Throwable tr, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 5)) {
            try {
                String message = args.length > 0 ? String.format(format, args) : format;
                int r = Log.w((String)tag, (String)message, (Throwable)tr);
                QCloudLogger.flush(tag, RecordLevel.INFO, message, tr);
                return r;
            }
            catch (Exception e) {
                return Log.w((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int e(String tag, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 6)) {
            try {
                String message = args.length > 0 ? String.format(format, args) : format;
                int r = Log.e((String)tag, (String)message);
                QCloudLogger.flush(tag, RecordLevel.INFO, message, null);
                return r;
            }
            catch (Exception e) {
                return Log.e((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static int e(String tag, Throwable tr, String format, Object ... args) {
        if (QCloudLogger.isLoggable(tag, 6)) {
            try {
                String message = args.length > 0 ? String.format(format, args) : format;
                int r = Log.e((String)tag, (String)message, (Throwable)tr);
                QCloudLogger.flush(tag, RecordLevel.INFO, message, tr);
                return r;
            }
            catch (Exception e) {
                return Log.e((String)tag, (String)(format + ": !!!! Log format exception: "), (Throwable)e);
            }
        }
        return 0;
    }

    public static boolean isTagLoggable(String tag) {
        return QCloudLogger.isLoggable(tag, 3);
    }

    private static boolean isLoggable(String tag, int level) {
        if (TextUtils.isEmpty((CharSequence)tag) || tag.length() >= 23) {
            return false;
        }
        return Log.isLoggable((String)tag, (int)level);
    }

    private static void flush(String tag, RecordLevel level, String msg, Throwable t) {
        if (level.ordinal() >= RecordLevel.INFO.ordinal() && recordLog != null) {
            recordLog.appendRecord(tag, level, msg, t);
        }
    }
}

