/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.http.HttpLoggingInterceptor;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.RetryAndTrafficControlInterceptor;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.Task;
import com.tencent.qcloud.core.task.TaskManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public final class QCloudHttpClient {
    static final String HTTP_LOG_TAG = "QCloudHttp";
    private final OkHttpClient okHttpClient;
    private final TaskManager taskManager;
    private final HttpLoggingInterceptor logInterceptor;
    private final Set<String> verifiedHost;
    private static final QCloudHttpClient DEFAULT = new Builder().build();
    private HostnameVerifier mHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (QCloudHttpClient.this.verifiedHost.size() > 0) {
                for (String host : QCloudHttpClient.this.verifiedHost) {
                    if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(host, session)) continue;
                    return true;
                }
            }
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session);
        }
    };

    public static QCloudHttpClient getDefault() {
        return DEFAULT;
    }

    public void addVerifiedHost(String hostname) {
        if (hostname != null) {
            this.verifiedHost.add(hostname);
        }
    }

    public void setDebuggable(boolean debuggable) {
        this.logInterceptor.setLevel(debuggable || QCloudLogger.isTagLoggable(HTTP_LOG_TAG) ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
    }

    private QCloudHttpClient(Builder b) {
        this.verifiedHost = new HashSet<String>(5);
        this.taskManager = TaskManager.getInstance();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().followRedirects(true).followSslRedirects(true).hostnameVerifier(this.mHostnameVerifier);
        builder.connectTimeout((long)b.connectionTimeout, TimeUnit.MILLISECONDS).readTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)b.socketTimeout, TimeUnit.MILLISECONDS);
        this.logInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            @Override
            public void log(String message) {
                QCloudLogger.i(QCloudHttpClient.HTTP_LOG_TAG, message, new Object[0]);
            }
        });
        this.logInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        builder.addInterceptor((Interceptor)this.logInterceptor);
        this.setDebuggable(false);
        builder.addInterceptor((Interceptor)new RetryAndTrafficControlInterceptor());
        this.okHttpClient = builder.build();
    }

    public List<HttpTask> getTasksByTag(String tag) {
        ArrayList<HttpTask> tasks = new ArrayList<HttpTask>();
        if (tag == null) {
            return tasks;
        }
        List<Task> taskManagerSnapshot = this.taskManager.snapshot();
        for (Task task : taskManagerSnapshot) {
            if (!(task instanceof HttpTask) || !tag.equals(task.getTag())) continue;
            tasks.add((HttpTask)task);
        }
        return tasks;
    }

    public <T> HttpTask<T> resolveRequest(HttpRequest<T> request) {
        return this.handleRequest(request, null);
    }

    public <T> HttpTask<T> resolveRequest(QCloudHttpRequest<T> request, QCloudCredentialProvider credentialProvider) {
        return this.handleRequest(request, credentialProvider);
    }

    Call getOkHttpCall(Request okHttpRequest) {
        return this.okHttpClient.newCall(okHttpRequest);
    }

    private <T> HttpTask<T> handleRequest(HttpRequest<T> request, QCloudCredentialProvider credentialProvider) {
        request.addHeader("Host", request.host());
        return new HttpTask<T>(request, credentialProvider, this);
    }

    private static final class Builder {
        int connectionTimeout = 15000;
        int socketTimeout = 30000;

        public Builder setConnectionTimeout(int connectionTimeout) {
            if (connectionTimeout < 10000) {
                throw new IllegalArgumentException("connection timeout must be larger than 10 seconds.");
            }
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            if (socketTimeout < 10000) {
                throw new IllegalArgumentException("socket timeout must be larger than 10 seconds.");
            }
            this.socketTimeout = socketTimeout;
            return this;
        }

        public QCloudHttpClient build() {
            return new QCloudHttpClient(this);
        }
    }
}

