/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.util.QCloudStringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public class HttpRequest<T> {
    private final Request.Builder requestBuilder;
    private final Map<String, List<String>> headers;
    private final RequestBody requestBody;
    private final String method;
    private final Object tag;
    private final URL url;
    private final ResponseBodyConverter<T> responseBodyConverter;
    private final boolean calculateContentMD5;

    HttpRequest(Builder<T> builder) {
        this.requestBuilder = builder.requestBuilder;
        this.responseBodyConverter = builder.responseBodyConverter;
        this.headers = builder.headers;
        this.method = builder.method;
        this.calculateContentMD5 = builder.calculateContentMD5;
        this.tag = builder.tag == null ? this.toString() : builder.tag;
        this.url = builder.httpUrlBuilder.build().url();
        this.requestBody = builder.requestBodySerializer != null ? builder.requestBodySerializer.body() : null;
        this.requestBuilder.method(builder.method, this.requestBody);
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String header(String name) {
        List<String> values = this.headers.get(name);
        return values != null ? values.get(0) : null;
    }

    public Object tag() {
        return this.tag;
    }

    void setOkHttpRequestTag(String tag) {
        this.requestBuilder.tag((Object)tag);
    }

    public void addHeader(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null || values.size() < 1) {
            this.requestBuilder.addHeader(name, value);
            HttpRequest.addHeaderNameValue(this.headers, name, value);
        }
    }

    public void removeHeader(String name) {
        this.requestBuilder.removeHeader(name);
        this.headers.remove(name);
    }

    boolean shouldCalculateContentMD5() {
        return this.calculateContentMD5 && QCloudStringUtils.isEmpty(this.header("Content-MD5"));
    }

    public String method() {
        return this.method;
    }

    public String host() {
        return this.url.getHost();
    }

    public String contentType() {
        return this.requestBody.contentType().toString();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public URL url() {
        return this.url;
    }

    ResponseBodyConverter<T> getResponseBodyConverter() {
        return this.responseBodyConverter;
    }

    RequestBody getRequestBody() {
        return this.requestBody;
    }

    Request buildRealRequest() {
        return this.requestBuilder.build();
    }

    QCloudSignSourceProvider getSignProvider() {
        return null;
    }

    QCloudSigner getQCloudSigner() throws QCloudClientException {
        return null;
    }

    private static void addHeaderNameValue(Map<String, List<String>> headers, String name, String value) {
        List<String> values = headers.get(name);
        if (values == null) {
            values = new ArrayList<String>(2);
            headers.put(name, values);
        }
        values.add(value.trim());
    }

    public static class Builder<T> {
        Object tag;
        String method;
        Request.Builder requestBuilder;
        HttpUrl.Builder httpUrlBuilder;
        Map<String, List<String>> headers = new HashMap<String, List<String>>(10);
        RequestBodySerializer requestBodySerializer;
        ResponseBodyConverter<T> responseBodyConverter;
        boolean calculateContentMD5;
        boolean isCacheEnabled = true;

        public Builder() {
            this.httpUrlBuilder = new HttpUrl.Builder();
            this.requestBuilder = new Request.Builder();
        }

        public Builder<T> url(URL url) {
            this.httpUrlBuilder = HttpUrl.get((URL)url).newBuilder();
            return this;
        }

        public Builder<T> scheme(String scheme) {
            this.httpUrlBuilder.scheme(scheme);
            return this;
        }

        public Builder<T> tag(Object tag) {
            this.tag = tag;
            return this;
        }

        public Builder<T> host(String host) {
            this.httpUrlBuilder.host(host);
            return this;
        }

        public Builder<T> path(String path) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() > 0) {
                this.httpUrlBuilder.addPathSegments(path);
            }
            return this;
        }

        public Builder<T> method(String method) {
            this.method = method;
            return this;
        }

        public Builder<T> query(String key, String value) {
            if (key != null) {
                this.httpUrlBuilder.addQueryParameter(key, value);
            }
            return this;
        }

        public Builder<T> encodedQuery(String key, String value) {
            if (key != null) {
                this.httpUrlBuilder.addEncodedQueryParameter(key, value);
            }
            return this;
        }

        public Builder<T> query(Map<String, String> nameValues) {
            if (nameValues != null) {
                for (Map.Entry<String, String> entry : nameValues.entrySet()) {
                    String name = entry.getKey();
                    if (name == null) continue;
                    this.httpUrlBuilder.addQueryParameter(name, entry.getValue());
                }
            }
            return this;
        }

        public Builder<T> encodedQuery(Map<String, String> nameValues) {
            if (nameValues != null) {
                for (Map.Entry<String, String> entry : nameValues.entrySet()) {
                    String name = entry.getKey();
                    if (name == null) continue;
                    this.httpUrlBuilder.addEncodedQueryParameter(name, entry.getValue());
                }
            }
            return this;
        }

        public Builder<T> contentMD5() {
            this.calculateContentMD5 = true;
            return this;
        }

        public Builder<T> addHeader(String name, String value) {
            if (name != null && value != null) {
                this.requestBuilder.addHeader(name, value);
                HttpRequest.addHeaderNameValue(this.headers, name, value);
            }
            return this;
        }

        public Builder<T> addHeaders(Map<String, List<String>> headers) {
            if (headers != null) {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    String name = entry.getKey();
                    for (String value : entry.getValue()) {
                        if (name == null || value == null) continue;
                        this.requestBuilder.addHeader(name, value);
                        HttpRequest.addHeaderNameValue(headers, name, value);
                    }
                }
            }
            return this;
        }

        public Builder<T> removeHeader(String name) {
            this.requestBuilder.removeHeader(name);
            this.headers.remove(name);
            return this;
        }

        public Builder<T> userAgent(String userAgent) {
            this.requestBuilder.addHeader("User-Agent", userAgent);
            return this;
        }

        public Builder<T> setUseCache(boolean cacheEnabled) {
            this.isCacheEnabled = cacheEnabled;
            return this;
        }

        public Builder<T> body(RequestBodySerializer bodySerializer) {
            this.requestBodySerializer = bodySerializer;
            return this;
        }

        public Builder<T> converter(ResponseBodyConverter<T> responseBodyConverter) {
            this.responseBodyConverter = responseBodyConverter;
            return this;
        }

        protected void prepareBuild() {
            this.requestBuilder.url(this.httpUrlBuilder.build());
            if (!this.isCacheEnabled) {
                this.requestBuilder.cacheControl(CacheControl.FORCE_NETWORK);
            }
            if (this.responseBodyConverter == null) {
                this.responseBodyConverter = ResponseBodyConverter.string();
            }
        }

        public HttpRequest<T> build() {
            this.prepareBuild();
            return new HttpRequest(this);
        }
    }
}

