/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.COSXmlSigner;
import com.tencent.qcloud.core.auth.QCloudSigner;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SignerFactory {
    private static final String COS_XML_SIGNER = "CosXmlSigner";
    private static final Map<String, Class<? extends QCloudSigner>> SIGNERS = new ConcurrentHashMap<String, Class<? extends QCloudSigner>>();

    private SignerFactory() {
    }

    public static void registerSigner(String signerType, Class<? extends QCloudSigner> signerClass) {
        if (signerType == null) {
            throw new IllegalArgumentException("signerType cannot be null");
        }
        if (signerClass == null) {
            throw new IllegalArgumentException("signerClass cannot be null");
        }
        SIGNERS.put(signerType, signerClass);
    }

    public static QCloudSigner getSigner(String signerType) {
        return SignerFactory.lookupAndCreateSigner(signerType);
    }

    private static QCloudSigner lookupAndCreateSigner(String signerType) {
        return SignerFactory.createSigner(signerType);
    }

    private static QCloudSigner createSigner(String signerType) {
        QCloudSigner signer;
        Class<? extends QCloudSigner> signerClass = SIGNERS.get(signerType);
        if (signerClass == null) {
            return null;
        }
        try {
            signer = signerClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        return signer;
    }

    static {
        SIGNERS.put(COS_XML_SIGNER, COSXmlSigner.class);
    }
}

