/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.AuthConstants;
import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import com.tencent.qcloud.core.util.QCloudStringUtils;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public class COSXmlSignSourceProvider
implements QCloudSignSourceProvider {
    private Set<String> paras;
    private Set<String> realSignParas;
    private Set<String> realSignHeader;
    private Set<String> headers;
    private long duration;
    private String signTime;

    public COSXmlSignSourceProvider(long duration) {
        this.duration = duration;
        this.headers = new HashSet<String>();
        this.paras = new HashSet<String>();
        this.realSignHeader = new HashSet<String>();
        this.realSignParas = new HashSet<String>();
    }

    public void parameter(String key) {
        this.paras.add(key);
    }

    public void parameters(Set<String> keys) {
        if (keys != null) {
            this.paras.addAll(keys);
        }
    }

    public void header(String key) {
        this.headers.add(key);
    }

    public void headers(Set<String> keys) {
        if (keys != null) {
            this.headers.addAll(keys);
        }
    }

    @Override
    public <T> String source(HttpRequest<T> request) throws QCloudClientException {
        if (request == null) {
            return null;
        }
        if (this.headers.size() > 0) {
            String contentType;
            Set<String> lowerCaseHeaders = this.toLowerCase(this.headers);
            if (lowerCaseHeaders != null && lowerCaseHeaders.contains("Content-Type".toLowerCase()) && (contentType = request.contentType()) != null) {
                request.addHeader("Content-Type", contentType);
            }
            if (lowerCaseHeaders != null && lowerCaseHeaders.contains("Content-Length".toLowerCase())) {
                long contentLength;
                try {
                    contentLength = request.contentLength();
                }
                catch (IOException e) {
                    throw new QCloudClientException("read content length fails", e);
                }
                if (contentLength != -1L) {
                    request.addHeader("Content-Length", Long.toString(contentLength));
                    request.removeHeader("Transfer-Encoding");
                } else {
                    request.addHeader("Transfer-Encoding", "chunked");
                    request.removeHeader("Content-Length");
                }
            }
            if (lowerCaseHeaders != null && lowerCaseHeaders.contains("Date".toLowerCase())) {
                Date d = new Date();
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                request.addHeader("Date", format.format(d));
            }
        }
        StringBuilder formatString = new StringBuilder(request.method().toLowerCase());
        formatString.append("\n");
        String path = QCloudHttpUtils.urlDecodeString(request.url().getPath());
        formatString.append(path);
        formatString.append("\n");
        String paraString = this.queryStringForKeys(request.url(), this.paras, this.realSignParas);
        if (paraString == null) {
            paraString = "";
        }
        formatString.append(paraString);
        formatString.append("\n");
        String headerString = "";
        if (request.headers() != null) {
            headerString = this.headersStringForKeys(request.headers(), this.headers, this.realSignHeader);
        }
        formatString.append(headerString);
        formatString.append("\n");
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(AuthConstants.SHA1);
        stringToSign.append("\n");
        long currentTime = System.currentTimeMillis() / 1000L;
        long expiredTime = currentTime + this.duration;
        this.signTime = currentTime + ";" + expiredTime;
        stringToSign.append(this.signTime);
        stringToSign.append("\n");
        String formatStringSha1 = Utils.encodeHexString(Utils.sha1(formatString.toString()));
        stringToSign.append(formatStringSha1);
        stringToSign.append("\n");
        return stringToSign.toString();
    }

    String getRealHeaderList() {
        return this.sortAndJoinSemicolon(this.realSignHeader);
    }

    String getRealParameterList() {
        return this.sortAndJoinSemicolon(this.realSignParas);
    }

    String getSignTime() {
        return this.signTime;
    }

    private String sortAndJoinSemicolon(Set<String> values) {
        if (values == null) {
            return "";
        }
        TreeSet<String> set = new TreeSet<String>(values);
        StringBuilder str = new StringBuilder();
        for (String value : set) {
            if (!QCloudStringUtils.isEmpty(str.toString())) {
                str.append(";");
            }
            str.append(value);
        }
        return str.toString();
    }

    private Set<String> toLowerCase(Set<String> set) {
        if (set != null && set.size() > 0) {
            HashSet<String> lowerSet = new HashSet<String>();
            for (String key : set) {
                if (key == null) continue;
                lowerSet.add(key.toLowerCase());
            }
            return lowerSet;
        }
        return null;
    }

    private String queryStringForKeys(URL httpUrl, Set<String> keys, Set<String> realKeys) {
        StringBuilder out = new StringBuilder();
        boolean isFirst = true;
        LinkedList<String> orderKeys = new LinkedList<String>();
        for (String key : keys) {
            orderKeys.add(key.toLowerCase());
        }
        Collections.sort(orderKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        Map<String, List<String>> queryNameValues = QCloudHttpUtils.getDecodedQueryPair(httpUrl);
        Set<String> queryNames = queryNameValues.keySet();
        if (queryNames == null) {
            return "";
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String name : queryNames) {
            maps.put(name.toLowerCase(), name);
        }
        for (String key : orderKeys) {
            List<String> values = queryNameValues.get(maps.get(key));
            if (values == null) continue;
            for (String value : values) {
                if (!isFirst) {
                    out.append('&');
                }
                isFirst = false;
                realKeys.add(key.toLowerCase());
                out.append(key.toLowerCase());
                if (value == null) continue;
                out.append('=');
                out.append(value.toLowerCase());
            }
        }
        return out.toString();
    }

    private String headersStringForKeys(Map<String, List<String>> headers, Set<String> keys, Set<String> realKeys) {
        StringBuilder out = new StringBuilder();
        boolean isFirst = true;
        LinkedList<String> orderKeys = new LinkedList<String>();
        for (String key : keys) {
            orderKeys.add(key.toLowerCase());
        }
        Collections.sort(orderKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        Set<String> headerNames = headers.keySet();
        if (headerNames == null) {
            return "";
        }
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String name : headerNames) {
            maps.put(name.toLowerCase(), name);
        }
        for (String key : orderKeys) {
            List<String> values = headers.get(key);
            if (values == null) continue;
            for (String value : values) {
                if (!isFirst) {
                    out.append('&');
                }
                isFirst = false;
                out.append(key.toLowerCase());
                realKeys.add(key);
                if (value == null) continue;
                out.append('=');
                out.append(QCloudHttpUtils.urlEncodeString(value));
            }
        }
        return out.toString();
    }
}

