/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.response.serializer.body;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.exception.QCloudExceptionType;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.response.serializer.body.ResponseBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseSerializerHelper;
import java.io.IOException;
import java.util.Map;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseJsonBodyLowestSerializer
implements ResponseBodySerializer {
    private Logger logger = LoggerFactory.getLogger(ResponseJsonBodyLowestSerializer.class);
    private Class cls;

    public ResponseJsonBodyLowestSerializer(Class cls) {
        this.cls = cls;
    }

    @Override
    public QCloudResult serialize(Response response) throws QCloudException {
        if (response == null) {
            return null;
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return null;
        }
        String jsonString = null;
        try {
            jsonString = responseBody.string();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QCloudException(QCloudExceptionType.HTTP_RESPONSE_PARSE_FAILED, "get response to string failed");
        }
        finally {
            responseBody.close();
        }
        QCloudLogger.debug(this.logger, jsonString);
        QCloudResult fastJsonResult = null;
        try {
            fastJsonResult = (QCloudResult)JSON.parseObject((String)this.getOneDegreeJson(jsonString), (Class)this.cls);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new QCloudException(QCloudExceptionType.HTTP_RESPONSE_PARSE_FAILED, "fast json parse json string to object failed");
        }
        if (fastJsonResult == null) {
            fastJsonResult = ResponseSerializerHelper.noBodyResult(this.cls, response);
        }
        return fastJsonResult;
    }

    private String getOneDegreeJson(String jsonStr) {
        QCloudLogger.debug(this.logger, "before change : {}", jsonStr);
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        if (jsonObject == null) {
            return null;
        }
        ShouldRecursionHolder should = new ShouldRecursionHolder(false);
        do {
            should.setShould(false);
            jsonObject = this.jsonDegreeDown(jsonObject, should);
        } while (should.isShould());
        QCloudLogger.debug(this.logger, "after change : {}", jsonObject.toString());
        return jsonObject.toString();
    }

    private JSONObject jsonDegreeDown(JSONObject jsonObject, ShouldRecursionHolder should) {
        JSONObject downJson = new JSONObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            QCloudLogger.debug(this.logger, "class type is " + entry.getValue().getClass().toString());
            if (entry.getValue() instanceof JSONObject) {
                JSONObject innerJson = (JSONObject)entry.getValue();
                for (Map.Entry innerEntry : innerJson.entrySet()) {
                    downJson.put((String)innerEntry.getKey(), innerEntry.getValue());
                }
                should.setShould(true);
                continue;
            }
            downJson.put((String)entry.getKey(), entry.getValue());
        }
        return downJson;
    }

    private static class ShouldRecursionHolder {
        private boolean should;

        public ShouldRecursionHolder(boolean should) {
            this.should = should;
        }

        public boolean isShould() {
            return this.should;
        }

        public void setShould(boolean should) {
            this.should = should;
        }
    }
}

