/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.serializer.body;

import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.request.bodys.BodyUploadProgressListener;
import com.tencent.qcloud.network.request.bodys.InputStreamRequestBody;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import okhttp3.RequestBody;

public class RequestStreamBodySerializer
implements RequestBodySerializer {
    private InputStream inputStream;
    private String mimeType;
    private long length;
    private QCloudProgressListener progressListener;

    public RequestStreamBodySerializer(InputStream inputStream, long length, String mimeType) {
        this.inputStream = inputStream;
        this.mimeType = mimeType;
        this.length = length;
    }

    public RequestStreamBodySerializer(InputStream inputStream, String mimeType) {
        this.inputStream = inputStream;
        this.mimeType = mimeType;
        this.length = -1L;
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    @Override
    public RequestBody serialize() {
        if (this.length == -1L) {
            try {
                this.length = this.inputStream.available();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvalidParameterException("input stream available() failed");
            }
        }
        InputStreamRequestBody requestBody = new InputStreamRequestBody(this.inputStream, this.length, this.mimeType);
        requestBody.setProgressListener(new BodyUploadProgressListener(){

            @Override
            public void onProgress(long progress, long max) {
                if (RequestStreamBodySerializer.this.progressListener != null) {
                    RequestStreamBodySerializer.this.progressListener.onProgress(progress, max);
                }
            }
        });
        return requestBody;
    }
}

