/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request.bodys;

import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.bodys.BodyUploadProgressListener;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamRequestBody
extends RequestBody {
    private static final Logger logger = LoggerFactory.getLogger(InputStreamRequestBody.class);
    private final InputStream inputStream;
    private final String contentType;
    private final long length;
    private BodyUploadProgressListener progressListener;

    public void setProgressListener(BodyUploadProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public InputStreamRequestBody(InputStream inputStream, long length, String contentType) {
        this.inputStream = inputStream;
        this.contentType = contentType;
        this.length = length;
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        long all;
        Source source = Okio.source((InputStream)this.inputStream);
        long remain = all = this.length;
        int bufferSize = 2048;
        int percent = 0;
        try {
            while (remain > 0L) {
                int progress;
                long maxReadSize = Math.min((long)bufferSize, remain);
                long readLength = source.read(bufferedSink.buffer(), maxReadSize);
                if (readLength != -1L && (progress = (int)Math.floor(100.0 * (double)(all - (remain -= readLength)) / (double)all)) >= percent) {
                    ++percent;
                    if (this.progressListener != null) {
                        this.progressListener.onProgress(all - remain, all);
                    }
                }
                bufferedSink.flush();
            }
            QCloudLogger.info(logger, "file finished.");
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public long contentLength() throws IOException {
        return this.length;
    }
}

