/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.request;

import android.text.TextUtils;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public class QCloudOkHttpRequestBuilder
extends Request.Builder {
    private String qCloudHttpMethod;
    private RequestBody qCloudRequestBody;
    private HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder();
    private StringBuilder host = new StringBuilder();
    private String fullHost = null;
    private String fullUrl;
    private StringBuilder path = new StringBuilder();

    public QCloudOkHttpRequestBuilder scheme(String scheme) {
        this.httpUrlBuilder.scheme(scheme);
        return this;
    }

    public QCloudOkHttpRequestBuilder host(String host) {
        this.fullHost = host;
        return this;
    }

    public QCloudOkHttpRequestBuilder fullUrl(String url) {
        this.fullUrl = url;
        return this;
    }

    public QCloudOkHttpRequestBuilder hostAddFront(String part) {
        this.host.insert(0, part);
        return this;
    }

    public QCloudOkHttpRequestBuilder hostAddRear(String part) {
        this.host.append(part);
        return this;
    }

    public QCloudOkHttpRequestBuilder pathAddFront(String part) {
        this.path.insert(0, part);
        if (!part.startsWith("/")) {
            this.path.insert(0, "/");
        }
        return this;
    }

    public QCloudOkHttpRequestBuilder pathAddRear(String part) {
        if (!part.startsWith("/")) {
            this.path.append("/");
        }
        this.path.append(part);
        return this;
    }

    public QCloudOkHttpRequestBuilder method(String method) {
        this.qCloudHttpMethod = method;
        return this;
    }

    public QCloudOkHttpRequestBuilder query(String key, String value) {
        this.httpUrlBuilder.addQueryParameter(key, value);
        return this;
    }

    public QCloudOkHttpRequestBuilder body(RequestBody requestBody) {
        this.qCloudRequestBody = requestBody;
        return this;
    }

    public Request build() {
        this.method(this.qCloudHttpMethod, this.qCloudRequestBody);
        if (this.path.toString().startsWith("/")) {
            this.path = this.path.toString().length() >= 2 ? new StringBuilder(this.path.toString().substring(1, this.path.toString().length())) : new StringBuilder();
        }
        if (!TextUtils.isEmpty((CharSequence)this.fullHost)) {
            this.httpUrlBuilder.host(this.fullHost);
        } else if (!TextUtils.isEmpty((CharSequence)this.host.toString())) {
            this.httpUrlBuilder.host(this.host.toString());
        }
        this.httpUrlBuilder.addPathSegments(this.path.toString());
        if (TextUtils.isEmpty((CharSequence)this.fullUrl)) {
            this.url(this.httpUrlBuilder.build());
        } else {
            this.url(this.fullUrl);
        }
        return super.build();
    }
}

