/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.action;

import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.action.QCloudActionResultListener;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QCloudRequestAction
implements Callable {
    private Logger logger = LoggerFactory.getLogger(QCloudRequestAction.class);
    private Future future;
    private QCloudActionResultListener actionResultListener;
    protected QCloudHttpRequest httpRequest;

    public QCloudRequestAction(QCloudHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public Future getFuture() {
        return this.future;
    }

    public void setFuture(Future future) {
        this.future = future;
    }

    public void setActionResultListener(QCloudActionResultListener actionResultListener) {
        this.actionResultListener = actionResultListener;
    }

    public QCloudActionResultListener getActionResultListener() {
        return this.actionResultListener;
    }

    public abstract void execute() throws Exception;

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public Object call() throws Exception {
        block5: {
            try {
                this.execute();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.actionResultListener == null) break block5;
                this.actionResultListener.onFailed(this, new QCloudException(e));
                return null;
            }
        }
        if (this.actionResultListener != null) {
            QCloudLogger.debug(this.logger, "one block mission success");
            try {
                this.actionResultListener.onSuccess(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

