/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.response.serializer.body;

import com.tencent.qcloud.network.QCloudResult;
import com.tencent.qcloud.network.annotation.SequenceFieldKeySorter;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.response.serializer.body.ResponseBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseSerializerHelper;
import com.tencent.qcloud.network.response.serializer.body.ResponseXmlBodySerializer;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.IOException;
import java.util.Locale;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseXmlS3BodySerializer
implements ResponseBodySerializer {
    private Logger logger = LoggerFactory.getLogger(ResponseXmlBodySerializer.class);
    private Class cls;
    private final String S3_RESPONSE_ROOT_NODE = "s3_response_root_node";

    public ResponseXmlS3BodySerializer(Class cls) {
        this.cls = cls;
    }

    @Override
    public QCloudResult serialize(Response response) throws QCloudException {
        if (response == null) {
            return null;
        }
        if (response.body() != null) {
            try {
                String xmlString = response.body().string();
                int index = xmlString.lastIndexOf("?>");
                if (index >= 0) {
                    if (xmlString.length() > 2) {
                        xmlString = xmlString.substring(index + 2);
                    } else {
                        return null;
                    }
                }
                xmlString = String.format(Locale.ENGLISH, "<%s>%s%s%s</%s>", "s3_response_root_node", System.getProperty("line.separator"), xmlString, System.getProperty("line.separator"), "s3_response_root_node");
                XStream xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new SequenceFieldKeySorter())));
                QCloudLogger.debug(this.logger, xmlString);
                xStream.processAnnotations(this.cls);
                xStream.alias("s3_response_root_node", this.cls);
                return (QCloudResult)xStream.fromXML(xmlString);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ResponseSerializerHelper.noBodyResult(this.cls, response);
    }
}

