/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network;

import com.tencent.qcloud.network.QCloudHttpRequest;
import com.tencent.qcloud.network.QCloudRequest;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.PriorityQueue;

public class QCloudRequestBuffer {
    private PriorityQueue<QCloudHttpRequest> cacheQueue;
    private Deque<QCloudHttpRequest> runningDeque;
    private int maxLowPriorityConcurrent;
    private int maxNormalPriorityConcurrent;
    private int maxHighPriorityConcurrent;

    public QCloudRequestBuffer(int maxLowPriorityConcurrent, int maxNormalPriorityConcurrent, int maxHighPriorityConcurrent) {
        this.maxLowPriorityConcurrent = maxLowPriorityConcurrent;
        this.maxHighPriorityConcurrent = maxHighPriorityConcurrent;
        this.maxNormalPriorityConcurrent = maxNormalPriorityConcurrent;
        this.cacheQueue = new PriorityQueue<QCloudRequest>(5, new QCloudRequest.QCloudRequestComparator());
        this.runningDeque = new ArrayDeque<QCloudHttpRequest>();
    }

    public synchronized void add(QCloudHttpRequest request) {
        this.cacheQueue.add(request);
    }

    public synchronized QCloudHttpRequest next() {
        QCloudHttpRequest request = this.cacheQueue.peek();
        if (request != null && this.canRunningNow(request)) {
            this.runningDeque.add(request);
            return (QCloudHttpRequest)this.cacheQueue.remove();
        }
        return null;
    }

    public synchronized boolean remove(QCloudHttpRequest request) {
        return this.runningDeque.remove(request) || this.cacheQueue.remove(request);
    }

    public synchronized List<QCloudHttpRequest> list() {
        ArrayList<QCloudHttpRequest> requests = new ArrayList<QCloudHttpRequest>(this.runningDeque);
        requests.addAll(this.cacheQueue);
        return requests;
    }

    public synchronized void removeAll() {
        this.cacheQueue.clear();
        this.runningDeque.clear();
    }

    private boolean canRunningNow(QCloudHttpRequest request) {
        switch (request.getPriority()) {
            case Q_CLOUD_REQUEST_PRIORITY_LOW: {
                if (this.runningDeque.size() < this.maxLowPriorityConcurrent) {
                    return true;
                }
            }
            case Q_CLOUD_REQUEST_PRIORITY_NORMAL: {
                if (this.runningDeque.size() < this.maxNormalPriorityConcurrent) {
                    return true;
                }
            }
            case Q_CLOUD_REQUEST_PRIORITY_HIGH: {
                if (this.runningDeque.size() >= this.maxHighPriorityConcurrent) break;
                return true;
            }
        }
        return false;
    }
}

