/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.lbs;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.telephony.CellLocation;
import android.telephony.NeighboringCellInfo;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import com.tencent.stat.StatActionListener;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatServiceImpl;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.Util;
import com.tencent.stat.lbs.StatGpsOption;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class StatGpsMonitor {
    private static volatile StatGpsMonitor a = null;
    private LocationManager b = null;
    private volatile Location c = null;
    private volatile long d = 0L;
    private volatile Location e = null;
    private LocationListener f = null;
    private LocationListener g = null;
    private Handler h = null;
    private static StatLogger i = StatCommonHelper.getLogger();
    private Context j = StatServiceImpl.getContext(null);
    private boolean k = false;
    private PendingIntent l = null;
    private BroadcastReceiver m = null;
    private AlarmManager n = null;
    private static long o = 1800000L;
    private StatActionListener p = new StatActionListener(){

        @Override
        public void onBecameForeground() {
            StatGpsMonitor.this.f();
        }

        @Override
        public void onBecameBackground() {
            StatGpsMonitor.this.g();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatGpsMonitor getInstance() {
        if (a != null) return a;
        Class<StatGpsMonitor> clazz = StatGpsMonitor.class;
        synchronized (StatGpsMonitor.class) {
            if (a != null) return a;
            a = new StatGpsMonitor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public void init(StatGpsOption statGpsOption) {
        i.d("init StatGpsMonitor");
        HandlerThread handlerThread = new HandlerThread("fbilbs");
        handlerThread.start();
        this.h = new Handler(handlerThread.getLooper());
        this.n = (AlarmManager)this.j.getSystemService("alarm");
        this.b = (LocationManager)this.j.getSystemService("location");
        this.a(statGpsOption);
    }

    public void startMonitor() {
        if (!this.k) {
            i.d("startMonitor");
            StatServiceImpl.addActionListener(this.p);
            this.f();
            this.k = true;
        }
    }

    public void stopMonitor() {
        if (this.k) {
            i.d("stopMonitor");
            StatServiceImpl.removeActionListener(this.p);
            this.g();
            this.i();
            this.k = false;
        }
    }

    public Location getLastLocation() {
        return this.c;
    }

    private void d() {
        i.d("gps reportCurLocation:" + this.c);
        com.tencent.stat.lbs.a a2 = new com.tencent.stat.lbs.a(this.j, StatServiceImpl.getSessionID(this.j, false, null), null);
        StatServiceImpl.reportEvent(this.j, a2, null);
    }

    private void e() {
        try {
            this.d();
            this.f();
        }
        catch (Throwable throwable) {
            i.w(throwable);
        }
    }

    public static long getLbsReportDuration(Context context) {
        long l2 = Long.valueOf(StatConfig.getCustomProperty(context, "_lbs_du_", "0"));
        if (l2 > 30000L) {
            o = l2;
        }
        return o;
    }

    public static void setLbsReportDuration(Context context, long l2) {
        o = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void f() {
        try {
            long l2 = StatGpsMonitor.getLbsReportDuration(this.j);
            long l3 = System.currentTimeMillis();
            if (this.l == null) {
                Class<StatGpsMonitor> clazz = StatGpsMonitor.class;
                // MONITORENTER : com.tencent.stat.lbs.StatGpsMonitor.class
                if (this.l == null) {
                    Intent intent = new Intent("com.tencent.fbi.lbs.report.action");
                    this.l = PendingIntent.getBroadcast((Context)this.j, (int)0, (Intent)intent, (int)0x8000000);
                    this.d();
                    this.m = new BroadcastReceiver(){

                        public void onReceive(Context context, Intent intent) {
                            i.i("hearbeat onReceive:" + intent);
                            StatGpsMonitor.this.h.post(new Runnable(){

                                @Override
                                public void run() {
                                    StatGpsMonitor.this.e();
                                }
                            });
                        }
                    };
                    try {
                        i.i("registerReceiver:" + this.m);
                        this.j.registerReceiver(this.m, new IntentFilter("com.tencent.fbi.lbs.report.action"));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                // MONITOREXIT : clazz
            }
            long l4 = l2;
            i.i("AlarmManager set reportInterval:" + l4 + ",reportPendingIntent:" + this.l);
            long l5 = l3 + l4;
            this.n.set(0, l5, this.l);
            return;
        }
        catch (Throwable throwable) {
            i.w(throwable);
        }
    }

    private void g() {
        try {
            i.i("stopReporting, reportPendingIntent=" + this.l + ",reportBroadcastReceiver=" + this.m);
            if (this.l != null) {
                this.n.cancel(this.l);
                this.l = null;
            }
            if (this.m != null) {
                this.j.unregisterReceiver(this.m);
                this.m = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    JSONObject a() {
        try {
            CdmaCellLocation cdmaCellLocation;
            JSONObject jSONObject = new JSONObject();
            TelephonyManager telephonyManager = (TelephonyManager)this.j.getSystemService("phone");
            String string = telephonyManager.getNetworkOperator();
            CellLocation cellLocation = telephonyManager.getCellLocation();
            if (cellLocation instanceof GsmCellLocation) {
                i.i("CellLocation type:GsmCellLocation:" + cellLocation);
                jSONObject.put("type", (Object)"gsm");
                jSONObject.put("lac", ((GsmCellLocation)cellLocation).getLac());
                jSONObject.put("cid", ((GsmCellLocation)cellLocation).getCid());
                if (string != null && string.length() >= 6) {
                    jSONObject.put("op", (Object)string);
                    jSONObject.put("mcc", (Object)string.substring(0, 3));
                    jSONObject.put("mnc", (Object)string.substring(3, 5));
                }
            } else if (cellLocation instanceof CdmaCellLocation) {
                i.i("CellLocation type:CdmaCellLocation:" + cellLocation);
                cdmaCellLocation = (CdmaCellLocation)cellLocation;
                jSONObject.put("type", (Object)"cdma");
                jSONObject.put("lac", cdmaCellLocation.getNetworkId());
                jSONObject.put("cid", cdmaCellLocation.getBaseStationId());
                jSONObject.put("lat", cdmaCellLocation.getBaseStationLatitude());
                jSONObject.put("lng", cdmaCellLocation.getBaseStationLongitude());
                if (string != null && string.length() >= 6) {
                    jSONObject.put("op", (Object)string);
                    jSONObject.put("mcc", (Object)string.substring(0, 3));
                    jSONObject.put("mnc", (Object)(cdmaCellLocation.getSystemId() + ""));
                }
            } else {
                i.w("error CellLocation type");
                return null;
            }
            jSONObject.put("nt", telephonyManager.getNetworkType());
            i.i("cellLoc:" + jSONObject);
            cdmaCellLocation = new JSONArray();
            List list = telephonyManager.getNeighboringCellInfo();
            if (list != null && list.size() > 0) {
                i.i("infoLists:" + list + "     size:" + list.size());
                for (NeighboringCellInfo neighboringCellInfo : list) {
                    i.i("get neighboringCellInfo:" + neighboringCellInfo);
                    if (neighboringCellInfo.getRssi() == 99 || neighboringCellInfo.getCid() == -1) continue;
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("dBm", -133 + 2 * neighboringCellInfo.getRssi());
                    jSONObject2.put("rssi", neighboringCellInfo.getRssi());
                    jSONObject2.put("lac", neighboringCellInfo.getLac());
                    jSONObject2.put("cid", neighboringCellInfo.getCid());
                    cdmaCellLocation.put((Object)jSONObject2);
                }
            }
            if (cdmaCellLocation != null && cdmaCellLocation.length() > 0) {
                jSONObject.put("nb", (Object)cdmaCellLocation);
            }
            return jSONObject;
        }
        catch (Throwable throwable) {
            i.e(throwable);
            return null;
        }
    }

    JSONObject b() {
        JSONObject jSONObject = new JSONObject();
        if (this.c != null) {
            Util.safeJsonPut(jSONObject, "lat", this.c.getLatitude());
            Util.safeJsonPut(jSONObject, "lng", this.c.getLongitude());
            Util.safeJsonPut(jSONObject, "alt", this.c.getAltitude());
            Util.safeJsonPut(jSONObject, "bear", Float.valueOf(this.c.getBearing()));
            Util.safeJsonPut(jSONObject, "acc", Float.valueOf(this.c.getAccuracy()));
            Util.safeJsonPut(jSONObject, "time", this.c.getTime());
            Util.safeJsonPut(jSONObject, "sp", Float.valueOf(this.c.getSpeed()));
            Util.safeJsonPut(jSONObject, "pvd", this.c.getProvider());
        }
        return jSONObject;
    }

    private String h() {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(1);
        criteria.setAltitudeRequired(false);
        criteria.setBearingRequired(false);
        criteria.setCostAllowed(false);
        criteria.setPowerRequirement(1);
        return this.b.getBestProvider(criteria, true);
    }

    private void a(StatGpsOption statGpsOption) {
        i.d("registerGps");
        StatGpsOption statGpsOption2 = statGpsOption;
        if (statGpsOption2 == null) {
            statGpsOption2 = new StatGpsOption();
        }
        this.b(statGpsOption2);
        this.c(statGpsOption2);
    }

    private void b(final StatGpsOption statGpsOption) {
        if (this.f == null && this.h != null) {
            this.h.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        i.d("registerGpsLocationListener");
                        StatGpsMonitor.this.f = new a("gps");
                        String string = StatGpsMonitor.this.h();
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            Location location = StatGpsMonitor.this.b.getLastKnownLocation(string);
                            if (StatGpsMonitor.this.a(StatGpsMonitor.this.c, location)) {
                                StatGpsMonitor.this.c = location;
                            }
                            StatGpsMonitor.this.b.requestLocationUpdates("gps", statGpsOption.getMinTime(), statGpsOption.getMinDistance(), StatGpsMonitor.this.f);
                        }
                    }
                    catch (Throwable throwable) {
                        i.e(throwable);
                    }
                }
            });
        }
    }

    private void c(final StatGpsOption statGpsOption) {
        if (this.g == null && this.h != null) {
            this.h.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        i.d("registerNetworkLocationListener");
                        StatGpsMonitor.this.g = new a("network");
                        String string = StatGpsMonitor.this.h();
                        if (string != null) {
                            Location location = StatGpsMonitor.this.b.getLastKnownLocation(StatGpsMonitor.this.h());
                            if (StatGpsMonitor.this.a(StatGpsMonitor.this.c, location)) {
                                StatGpsMonitor.this.c = location;
                            }
                            StatGpsMonitor.this.b.requestLocationUpdates("gps", statGpsOption.getMinTime(), statGpsOption.getMinDistance(), StatGpsMonitor.this.g);
                        }
                    }
                    catch (Throwable throwable) {
                        i.e(throwable);
                    }
                }
            });
        }
    }

    private void i() {
        this.j();
        this.k();
    }

    private void j() {
        if (this.f != null) {
            this.b.removeUpdates(this.f);
            this.f = null;
        }
    }

    private void k() {
        if (this.g != null) {
            this.b.removeUpdates(this.g);
            this.f = null;
        }
    }

    private boolean a(Location location, Location location2) {
        boolean bl;
        if (location2 == null) {
            return true;
        }
        if (location == null) {
            return false;
        }
        long l2 = location.getTime() - location2.getTime();
        boolean bl2 = l2 > 120000L;
        boolean bl3 = l2 < -120000L;
        boolean bl4 = bl = l2 > 0L;
        if (bl2) {
            return true;
        }
        if (bl3) {
            return false;
        }
        int n2 = (int)(location.getAccuracy() - location2.getAccuracy());
        boolean bl5 = n2 > 0;
        boolean bl6 = n2 < 0;
        boolean bl7 = n2 > 200;
        boolean bl8 = this.a(location.getProvider(), location2.getProvider());
        if (bl6) {
            return true;
        }
        if (bl && !bl5) {
            return true;
        }
        return bl && !bl7 && bl8;
    }

    private boolean a(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private class a
    implements LocationListener {
        private String b = "";

        public a(String string) {
            this.b = string;
        }

        public void onStatusChanged(String string, int n2, Bundle bundle) {
            i.i(this.b + " gps onStatusChanged status:" + n2 + ",extras:" + bundle + ", provider:" + string);
            switch (n2) {
                case 2: {
                    i.i(string + " AVAILABLE gps");
                    break;
                }
                case 0: {
                    i.i(string + " OUT_OF_SERVICE gps");
                    break;
                }
                case 1: {
                    i.i(string + " TEMPORARILY_UNAVAILABLE gps");
                }
            }
        }

        public void onProviderEnabled(String string) {
            i.d(this.b + " gps onProviderEnabled provider:" + string);
            if (StatGpsMonitor.this.c == null) {
                try {
                    StatGpsMonitor.this.c = StatGpsMonitor.this.b.getLastKnownLocation(StatGpsMonitor.this.h());
                }
                catch (Exception exception) {
                    i.e(exception);
                }
            }
        }

        public void onProviderDisabled(String string) {
            i.d(this.b + " gps onProviderDisabled provider:" + string);
        }

        public void onLocationChanged(Location location) {
            if (location != null) {
                i.i(this.b + " gps onLocationChanged location:" + location.getLatitude() + "," + location.getLongitude() + "," + location.getTime() + "==?" + System.currentTimeMillis());
                if (StatGpsMonitor.this.a(location, StatGpsMonitor.this.c)) {
                    StatGpsMonitor.this.c = location;
                }
            }
        }
    }
}

