/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat.common;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.tencent.mid.api.MidService;
import com.tencent.stat.StatConfig;
import com.tencent.stat.common.e;
import com.tencent.stat.common.h;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Util {
    private static String a = null;
    private static String b = "";

    public static boolean checkPermission(Context context, String string) {
        boolean bl = false;
        try {
            PackageManager packageManager = context.getPackageManager();
            bl = packageManager.checkPermission(string, context.getPackageName()) == 0;
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"checkPermission error", (Throwable)throwable);
        }
        return bl;
    }

    public static String getSimOperator(Context context) {
        String string = null;
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager != null) {
                    string = telephonyManager.getSimOperator();
                }
            } else {
                Log.e((String)"MtaSDK", (String)"Could not get permission of android.permission.READ_PHONE_STATE");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"", (Throwable)throwable);
        }
        return string;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static Integer getTelephonyNetworkType(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                return telephonyManager.getNetworkType();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getExternalStorageInfo(Context context) {
        block4: {
            try {
                if (Util.checkPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    String string;
                    String string2 = Environment.getExternalStorageState();
                    if (string2 != null && string2.equals("mounted") && (string = Environment.getExternalStorageDirectory().getPath()) != null) {
                        StatFs statFs = new StatFs(string);
                        long l2 = (long)statFs.getBlockCount() * (long)statFs.getBlockSize() / 1000000L;
                        long l3 = (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize() / 1000000L;
                        return String.valueOf(l3) + "/" + String.valueOf(l2);
                    }
                    break block4;
                }
                Log.e((String)"MtaSDK", (String)"can not get the permission of android.permission.WRITE_EXTERNAL_STORAGE");
                return null;
            }
            catch (Throwable throwable) {
                Log.e((String)"MtaSDK", (String)"", (Throwable)throwable);
            }
        }
        return null;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static Context getContextSelf(Context context) {
        if (context != null && context.getApplicationContext() != null) {
            return context.getApplicationContext();
        }
        return context;
    }

    public static String getLinkedWay(Context context) {
        String string = null;
        try {
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected()) {
                    String string2 = networkInfo.getTypeName();
                    String string3 = networkInfo.getExtraInfo();
                    if (string2 != null) {
                        string = string2.equalsIgnoreCase("WIFI") ? "WIFI" : (string2.equalsIgnoreCase("MOBILE") ? (string3 != null && string3.trim().length() > 0 ? string3 : "MOBILE") : (string3 != null && string3.trim().length() > 0 ? string3 : string2));
                    }
                }
            } else {
                Log.e((String)"MtaSDK", (String)"can not get the permission of android.permission.ACCESS_WIFI_STATE");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"", (Throwable)throwable);
        }
        return string;
    }

    public static String getDeviceID(Context context) {
        try {
            if (Util.checkPermission(context, "android.permission.READ_PHONE_STATE")) {
                String string = "";
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                string = telephonyManager.getDeviceId();
                if (string != null) {
                    return string;
                }
            } else {
                Log.e((String)"MtaSDK", (String)"Could not get permission of android.permission.READ_PHONE_STATE");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"get device id error", (Throwable)throwable);
        }
        return null;
    }

    public static boolean isIMEI(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            int n2 = string.trim().length();
            return n2 == 14 || n2 == 15;
        }
        return false;
    }

    public static String getNewUi(Context context) {
        String string;
        if (TextUtils.isEmpty((CharSequence)a) && Util.isIMEI(string = Util.getDeviceID(context))) {
            a = string;
        }
        return a;
    }

    public static String getWifiMacAddress(Context context) {
        if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager == null) {
                    return "";
                }
                return wifiManager.getConnectionInfo().getMacAddress();
            }
            catch (Exception exception) {
                Log.e((String)"MtaSDK", (String)"get wifi address error", (Throwable)exception);
                return "";
            }
        }
        Log.e((String)"MtaSDK", (String)"Could not get permission of android.permission.ACCESS_WIFI_STATE");
        return "";
    }

    public static String decode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = h.a(byArray, 0);
            byArray2 = e.b(byArray2);
            return new String(byArray2, "UTF-8");
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"decode error", (Throwable)throwable);
            return string;
        }
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 8) {
            return string;
        }
        try {
            byte[] byArray = e.a(string.getBytes("UTF-8"));
            byte[] byArray2 = h.b(byArray, 0);
            return new String(byArray2, "UTF-8");
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"encode error", (Throwable)throwable);
            return string;
        }
    }

    public static void jsonPut(JSONObject jSONObject, String string, String string2) {
        try {
            if (string2 != null && string2.length() > 0) {
                jSONObject.put(string, (Object)string2);
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"jsonPut error", (Throwable)throwable);
        }
    }

    public static void safeJsonPut(JSONObject jSONObject, String string, Object object) {
        try {
            jSONObject.put(string, object);
        }
        catch (Exception exception) {
            Log.e((String)"MtaSDK", (String)"safeJsonPut error", (Throwable)exception);
        }
    }

    public static WifiInfo getWifiInfo(Context context) {
        WifiManager wifiManager;
        if (Util.checkPermission(context, "android.permission.ACCESS_WIFI_STATE") && (wifiManager = (WifiManager)context.getSystemService("wifi")) != null) {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            return wifiInfo;
        }
        return null;
    }

    public static JSONObject getConnecetedWifiInfo(Context context) {
        WifiInfo wifiInfo = Util.getWifiInfo(context);
        try {
            if (wifiInfo != null) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("bs", (Object)wifiInfo.getBSSID());
                jSONObject.put("ss", (Object)wifiInfo.getSSID());
                jSONObject.put("dBm", wifiInfo.getRssi());
                return jSONObject;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String getWiFiBBSID(Context context) {
        try {
            WifiInfo wifiInfo = Util.getWifiInfo(context);
            if (wifiInfo != null) {
                return wifiInfo.getBSSID();
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"encode error", (Throwable)throwable);
        }
        return null;
    }

    public static String getWiFiSSID(Context context) {
        try {
            WifiInfo wifiInfo = Util.getWifiInfo(context);
            if (wifiInfo != null) {
                return wifiInfo.getSSID();
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"encode error", (Throwable)throwable);
        }
        return null;
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager != null) {
                    NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                    if (networkInfo != null && networkInfo.isAvailable()) {
                        return true;
                    }
                    Log.w((String)"MtaSDK", (String)"Network error");
                    return false;
                }
            } else {
                Log.e((String)"MtaSDK", (String)"can not get the permisson of android.permission.INTERNET");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"isNetworkAvailable error", (Throwable)throwable);
        }
        return false;
    }

    public static boolean isWifiNet(Context context) {
        try {
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                if (connectivityManager != null) {
                    NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                    return networkInfo != null && networkInfo.isAvailable() && networkInfo.getTypeName().equalsIgnoreCase("WIFI");
                }
            } else {
                Log.e((String)"MtaSDK", (String)"can not get the permisson of android.permission.INTERNET");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"isWifiNet error", (Throwable)throwable);
        }
        return false;
    }

    public static JSONArray getWifiTopN(Context context, int n2) {
        try {
            if (!StatConfig.isEnableReportWifiList()) {
                return null;
            }
            if (Util.checkPermission(context, "android.permission.INTERNET") && Util.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
                List list;
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                if (wifiManager != null && (list = wifiManager.getScanResults()) != null && list.size() > 0) {
                    Collections.sort(list, new Comparator<ScanResult>(){

                        public int a(ScanResult scanResult, ScanResult scanResult2) {
                            int n2;
                            int n3 = Math.abs(scanResult.level);
                            if (n3 > (n2 = Math.abs(scanResult2.level))) {
                                return 1;
                            }
                            return n3 == n2 ? 0 : -1;
                        }

                        @Override
                        public /* synthetic */ int compare(Object object, Object object2) {
                            return this.a((ScanResult)object, (ScanResult)object2);
                        }
                    });
                    JSONArray jSONArray = new JSONArray();
                    for (int i2 = 0; i2 < list.size() && i2 < n2; ++i2) {
                        ScanResult scanResult = (ScanResult)list.get(i2);
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("bs", (Object)scanResult.BSSID);
                        jSONObject.put("ss", (Object)scanResult.SSID);
                        jSONObject.put("dBm", scanResult.level);
                        jSONArray.put((Object)jSONObject);
                    }
                    return jSONArray;
                }
            } else {
                Log.e((String)"MtaSDK", (String)"can not get the permisson of android.permission.INTERNET");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"MtaSDK", (String)"isWifiNet error", (Throwable)throwable);
        }
        return null;
    }

    public static String getMid(Context context) {
        if (com.tencent.mid.util.Util.isMidValid((String)b)) {
            return b;
        }
        return MidService.getMid((Context)context);
    }
}

