/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.stat;

import android.content.Context;
import android.os.Build;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatServiceImpl;
import com.tencent.stat.common.StatCommonHelper;
import com.tencent.stat.common.StatLogger;
import com.tencent.stat.common.StatPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.json.JSONArray;

public class StatNativeCrashReport {
    private static StatLogger b = StatCommonHelper.getLogger();
    static StatNativeCrashReport a = new StatNativeCrashReport();
    private volatile boolean c = false;
    public static final String PRE_TAG_TOMBSTONE_FNAME = "tombstone_";
    private static JSONArray d;
    private static Thread e;
    private static boolean f;
    private static boolean g;
    private static String h;
    private static boolean i;
    public static final String SO_LOAD_NAME = "MtaNativeCrash_v2";
    public static final String SO_FULL_NAME = "libMtaNativeCrash_v2.so";

    public native String stringFromJNI();

    public native boolean initJNICrash(String var1, int var2);

    public native void enableNativeCrashDebug(boolean var1);

    public native void enableNativeCrash(boolean var1);

    public native String makeJniCrash();

    static JSONArray a() {
        JSONArray jSONArray = new JSONArray();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray != null) {
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (stackTraceElement.getClassName().equals(StatNativeCrashReport.class.getName())) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                jSONArray.put((Object)stackTraceElement.toString());
            }
        }
        return jSONArray;
    }

    private static void b() {
        d = StatNativeCrashReport.a();
        e = Thread.currentThread();
    }

    public static void createNativeCrashEvent(String string) {
        b.d("createNativeCrashEvent:" + string);
        StatServiceImpl.a(StatServiceImpl.getContext(null), null, true);
        StatNativeCrashReport.b();
        StatServiceImpl.a(d, e, string);
    }

    public static void doNativeCrashTest() {
        if (!i) {
            b.w("libMtaNativeCrash_v2.so not loaded.");
            return;
        }
        a.makeJniCrash();
    }

    public static void setNativeCrashEnable(boolean bl) {
        if (!i) {
            b.w("libMtaNativeCrash_v2.so not loaded.");
            return;
        }
        try {
            a.enableNativeCrash(bl);
            f = bl;
        }
        catch (Throwable throwable) {
            b.w(throwable);
        }
    }

    public static boolean isNativeCrashEnable() {
        return f;
    }

    public static void setNativeCrashDebugEnable(boolean bl) {
        if (!i) {
            b.w("libMtaNativeCrash_v2.so not loaded.");
            return;
        }
        try {
            a.enableNativeCrashDebug(bl);
            g = bl;
        }
        catch (Throwable throwable) {
            b.w(throwable);
        }
    }

    public static boolean isNativeCrashDebugEnable() {
        return g;
    }

    public static void initNativeCrash(Context context, String string) {
        if (!i) {
            b.w("libMtaNativeCrash_v2.so not loaded.");
            return;
        }
        if (StatNativeCrashReport.a.c) {
            return;
        }
        try {
            if (string == null) {
                string = context.getDir("tombstones", 0).getAbsolutePath();
            }
            h = string;
            StatPreferences.putString(context, "__mta_tombstone__", string);
            StatNativeCrashReport.setNativeCrashEnable(true);
            a.initJNICrash(string, Build.VERSION.SDK_INT);
            StatNativeCrashReport.a.c = true;
            if (StatConfig.isDebugEnable()) {
                b.d("initNativeCrash success.");
            }
        }
        catch (Throwable throwable) {
            b.w(throwable);
        }
    }

    public static String getTombstonesDir(Context context) {
        if (h == null) {
            h = StatPreferences.getString(context, "__mta_tombstone__", "");
        }
        return h;
    }

    public static String readFile(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            b.e(iOException);
        }
        return stringBuilder.toString();
    }

    public static LinkedHashSet<File> getCrashEventsFilesList(Context context) {
        File[] fileArray;
        File file;
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        String string = context.getDir("mtajcrash", 0).getAbsolutePath();
        if (string != null && (file = new File(string)) != null && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (file2.exists() && file2.length() > 0x100000L) {
                    try {
                        file2.delete();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                if (!file2.getName().endsWith(".v1.crash") || !file2.isFile()) continue;
                if (StatConfig.isDebugEnable()) {
                    b.d("get tombstone file:" + file2.getAbsolutePath().toString());
                }
                linkedHashSet.add(file2.getAbsoluteFile());
            }
        }
        return linkedHashSet;
    }

    static {
        e = null;
        f = false;
        g = false;
        h = null;
        i = false;
        try {
            System.loadLibrary(SO_LOAD_NAME);
            i = true;
        }
        catch (Throwable throwable) {
            f = false;
            b.w("can't find libMtaNativeCrash_v2.so, NativeCrash report disable.");
        }
    }
}

