/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.logUtils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.qcloud.logUtils.R;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LogActivity
extends AppCompatActivity {
    private static String TAG = LogActivity.class.getSimpleName();
    private SwipeRefreshLayout swipeRefreshLayout;
    private RecyclerView recyclerView;
    private CustomerAdapter customerAdapter;
    private RecyclerView.OnScrollListener onScrollListener;
    private Handler mainHandler = new Handler(Looper.getMainLooper());

    protected void onCreate(Bundle savedInstanceState) {
        this.supportRequestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_log);
        this.findViewById(R.id.backId).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LogActivity.this.finish();
            }
        });
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipeRefreshId);
        this.swipeRefreshLayout.setEnabled(false);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.item_list);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)this);
        linearLayoutManager.setOrientation(1);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.customerAdapter = new CustomerAdapter((Context)this);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.customerAdapter);
        this.mainHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = LogActivity.this.getIntent().getExtras();
                if (bundle != null) {
                    String parentPath = bundle.getString("FILE_PARENT_PATH", null);
                    ArrayList fileNameList = bundle.getStringArrayList("FILE_NAME");
                    LogActivity.this.initItems(parentPath, fileNameList);
                }
            }
        }, 30L);
    }

    private void initItems(String parentPath, List<String> fileNameList) {
        if (fileNameList != null && parentPath != null) {
            this.customerAdapter.fileParentPath = parentPath;
            this.customerAdapter.items.addAll(fileNameList);
            this.customerAdapter.notifyDataSetChanged();
        }
    }

    public void dropDownRefresh() {
    }

    public void pullUpRefresh() {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)this.recyclerView.getLayoutManager();
        int lastPosition = linearLayoutManager.findLastCompletelyVisibleItemPosition();
        if (lastPosition == this.customerAdapter.items.size() - 1) {
            // empty if block
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.recyclerView != null && this.onScrollListener != null) {
            this.recyclerView.removeOnScrollListener(this.onScrollListener);
        }
        if (this.customerAdapter != null) {
            this.customerAdapter.clear();
        }
    }

    private static class CustomerViewHolder
    extends RecyclerView.ViewHolder {
        private TextView filePathTextView;
        private ImageView actionImageView;

        public CustomerViewHolder(View itemView) {
            super(itemView);
            this.filePathTextView = (TextView)itemView.findViewById(R.id.pathId);
            this.actionImageView = (ImageView)itemView.findViewById(R.id.actionId);
        }

        public void setOnClickListener(View.OnClickListener onClickListener) {
            this.filePathTextView.setOnClickListener(onClickListener);
        }
    }

    private static class CustomerAdapter
    extends RecyclerView.Adapter<CustomerViewHolder> {
        private List<String> items = new ArrayList<String>(30);
        private String fileParentPath;
        private Context context;

        public CustomerAdapter(Context context) {
            this.context = context;
        }

        private void share(String filePath) {
            Intent fileIntent = new Intent("android.intent.action.SEND");
            fileIntent.setType("*/*");
            fileIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)filePath));
            this.context.startActivity(Intent.createChooser((Intent)fileIntent, (CharSequence)"\u5206\u4eab"));
        }

        public void clear() {
            this.items.clear();
        }

        @NonNull
        public CustomerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.item_log, parent, false);
            final CustomerViewHolder customerViewHolder = new CustomerViewHolder(view);
            customerViewHolder.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String filePath = CustomerAdapter.this.fileParentPath + File.separator + customerViewHolder.filePathTextView.getText().toString().trim();
                    Log.d((String)TAG, (String)filePath);
                    CustomerAdapter.this.share(filePath);
                }
            });
            return customerViewHolder;
        }

        public void onBindViewHolder(@NonNull CustomerViewHolder holder, int position) {
            holder.filePathTextView.setText((CharSequence)this.items.get(position));
        }

        public int getItemCount() {
            return this.items.size();
        }
    }
}

