/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.List;
import java.util.Locale;

public class ImageTagDetectResult
extends QImageResult {
    private int code;
    private String message;
    private List<ImageTagResult> imageTagResults;

    public ImageTagDetectResult(int httpCode, String httpMessage, int code, String message, List<ImageTagResult> imageTagResults) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
        this.imageTagResults = imageTagResults;
    }

    public ImageTagDetectResult(int httpCode, String httpMessage, int code, String message) {
        this(httpCode, httpMessage, code, message, null);
    }

    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    public List<ImageTagResult> getImageTagResults() {
        return this.imageTagResults;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(String.format(Locale.US, "ImageTagDetectRequest : \n", new Object[0]));
        desc.append(String.format(Locale.US, "code = %d, message = %s\n", this.code, this.message));
        if (this.imageTagResults != null && !this.imageTagResults.isEmpty()) {
            for (ImageTagResult imageTagResult : this.imageTagResults) {
                String resultString = imageTagResult.toString();
                desc.append(resultString + "\n");
            }
        }
        return desc.toString();
    }

    public static class ImageTagResult {
        private String name;
        private int confidence;

        public ImageTagResult(String name, int confidence) {
            this.name = name;
            this.confidence = confidence;
        }

        public int getConfidence() {
            return this.confidence;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.format(Locale.US, "name = %s, confidence = %d", this.name, this.confidence);
        }
    }
}

