/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;

public class FaceSetPersonInfoRequest
extends QImageRequest {
    private String bucket;
    private String personId;
    private String personName;
    private String tag;

    public FaceSetPersonInfoRequest(String bucket, String personId, String personName, String tag, String sign) {
        super(sign);
        this.bucket = bucket;
        this.personId = personId;
        this.personName = personName;
        this.tag = tag;
    }

    public FaceSetPersonInfoRequest(String bucket, String personId, String personName, String tag) {
        this(bucket, personId, personName, tag, null);
    }

    public FaceSetPersonInfoRequest(String bucket, String personId, String sign) {
        this(bucket, personId, null, null, sign);
    }

    public FaceSetPersonInfoRequest(String bucket, String personId) {
        this(bucket, personId, null);
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.personId)) {
            throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getTag() {
        return this.tag;
    }

    public String getPersonName() {
        return this.personName;
    }
}

