/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FaceIdentifyResult
extends QImageResult {
    private final int code;
    private final String message;
    private final String sessionId;
    private final List<IdentifyItem> candidates;

    public FaceIdentifyResult(int httpCode, String httpMessage, int code, String message, String sessionId, List<IdentifyItem> candidates) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
        this.sessionId = sessionId;
        this.candidates = candidates;
    }

    public FaceIdentifyResult(int httpCode, String httpMessage, int code, String message) {
        this(httpCode, httpMessage, code, message, null, null);
    }

    public List<IdentifyItem> getCandidates() {
        return this.candidates;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(String.format(Locale.US, "http code = %d, http message = %s\n", this.httpCode, this.httpMessage));
        desc.append(String.format(Locale.US, "code = %d, message = %s\n", this.code, this.message));
        if (this.code == 0 && this.candidates != null && !this.candidates.isEmpty()) {
            desc.append(String.format(Locale.US, "session id = %s\ncontain person id list : \n", this.sessionId));
            Iterator<IdentifyItem> iterator = this.candidates.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                desc.append(String.format(Locale.US, "  candidates %d : %s\n", i++, iterator.next()));
            }
        }
        return desc.toString();
    }

    public static final class IdentifyItem {
        private final String personId;
        private final String faceId;
        private final double confidence;
        private final String tag;

        public IdentifyItem(String personId, String faceId, double confidence, String tag) {
            this.personId = personId;
            this.faceId = faceId;
            this.confidence = confidence;
            this.tag = tag;
        }

        public String getFaceId() {
            return this.faceId;
        }

        public double getConfidence() {
            return this.confidence;
        }

        public String getPersonId() {
            return this.personId;
        }

        public String getTag() {
            return this.tag;
        }

        public String toString() {
            return String.format(Locale.US, "face id = %s, person id = %s, confidence = %f, tag = %s", this.faceId, this.personId, this.confidence, this.tag);
        }
    }
}

