/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FaceDetectResult
extends QImageResult {
    private int code;
    private String message;
    private String sessionId;
    private int imageWidth;
    private int imageHeight;
    private List<FaceItem> faces;

    public FaceDetectResult(int httpCode, String httpMessage, int code, String message, String sessionId, int imageWidth, int imageHeight, List<FaceItem> faces) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
        this.sessionId = sessionId;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.faces = faces;
    }

    public FaceDetectResult(int httpCode, String httpMessage, int code, String message) {
        this(httpCode, httpMessage, code, message, null, 0, 0, null);
    }

    public List<FaceItem> getFaces() {
        return this.faces;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(String.format(Locale.US, "http code = %d, http message = %s\n", this.httpCode, this.httpMessage));
        desc.append(String.format(Locale.US, "code = %d, message = %s\n", this.code, this.message));
        if (this.code == 0 && this.faces != null && !this.faces.isEmpty()) {
            desc.append(String.format(Locale.US, "session = %s, image width = %d, image height = %d\n", this.sessionId, this.imageWidth, this.imageHeight));
            Iterator<FaceItem> iterator = this.faces.iterator();
            while (iterator.hasNext()) {
                desc.append(iterator.next() + "\n");
            }
        }
        return desc.toString();
    }

    public static class FaceItem {
        String faceId;
        int x;
        int y;
        double width;
        double height;
        int gender;
        int age;
        int expression;
        boolean glass;
        int pitch;
        int yaw;
        int roll;
        int beauty;

        public FaceItem(String faceId, int x, int y, double width, double height, int gender, int age, int expression, boolean glass, int pitch, int yaw, int roll, int beauty) {
            this.faceId = faceId;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.gender = gender;
            this.age = age;
            this.expression = expression;
            this.glass = glass;
            this.pitch = pitch;
            this.yaw = yaw;
            this.roll = roll;
            this.beauty = beauty;
        }

        public String getFaceId() {
            return this.faceId;
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public int getAge() {
            return this.age;
        }

        public int getExpression() {
            return this.expression;
        }

        public int getGender() {
            return this.gender;
        }

        public int getPitch() {
            return this.pitch;
        }

        public int getRoll() {
            return this.roll;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getYaw() {
            return this.yaw;
        }

        public int getBeauty() {
            return this.beauty;
        }

        public String toString() {
            return String.format(Locale.US, "face id = %s, x = %d, y = %d, width = %f, height = %f\ngender = %d, age = %d, expression = %d, glass = %b\npitch = %d, yaw = %d, roll = %d, beauty = %d", this.faceId, this.x, this.y, this.width, this.height, this.gender, this.age, this.expression, this.glass, this.pitch, this.yaw, this.roll, this.beauty);
        }
    }
}

