/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.QImageGlobalConfig;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class FaceAddFaceRequest
extends QImageRequest {
    private String bucket;
    private String personId;
    private Set<String> urlSet;
    private String imagePath;
    private String tag;

    public FaceAddFaceRequest(String bucket, String personId, String tag, String sign) {
        super(sign);
        this.bucket = bucket;
        this.personId = personId;
        this.tag = tag;
        this.urlSet = new LinkedHashSet<String>();
    }

    public FaceAddFaceRequest(String bucket, String personId, String sign) {
        this(bucket, personId, null, sign);
    }

    public FaceAddFaceRequest(String bucket, String personId) {
        this(bucket, personId, null);
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void addImageUrl(String imageUrl) throws ClientException {
        if (!TextUtils.isEmpty((CharSequence)this.imagePath)) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        if (this.urlSet.size() >= 20) {
            throw new ClientException(ClientExceptionType.OCR_ID_CARD_IMEGE_OR_URL_TOO_MUCH);
        }
        this.urlSet.add(imageUrl);
    }

    public void addImageUrl(LinkedHashSet<String> imageUrls) throws ClientException {
        if (!TextUtils.isEmpty((CharSequence)this.imagePath)) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        if (this.urlSet.size() + imageUrls.size() > 20) {
            throw new ClientException(ClientExceptionType.OCR_ID_CARD_IMEGE_OR_URL_TOO_MUCH);
        }
        this.urlSet.addAll(imageUrls);
    }

    public void setImagePath(String imagePath) throws ClientException {
        if (!this.urlSet.isEmpty()) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        this.imagePath = imagePath;
    }

    public void clearImagePath() {
        this.imagePath = null;
    }

    public void clearUrlSet() {
        if (this.urlSet != null && this.urlSet.size() > 0) {
            this.urlSet.clear();
        }
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.personId)) {
            throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
        }
        if (!TextUtils.isEmpty((CharSequence)this.imagePath) && this.urlSet != null && !this.urlSet.isEmpty()) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        if ((this.urlSet == null || this.urlSet.isEmpty()) && TextUtils.isEmpty((CharSequence)this.imagePath)) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (this.urlSet != null && this.urlSet.size() > 0) {
            Iterator<String> iterator = this.urlSet.iterator();
            while (iterator.hasNext()) {
                if (!TextUtils.isEmpty((CharSequence)iterator.next())) continue;
                throw new ClientException(ClientExceptionType.IMAGE_URL_IS_NULL);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.imagePath)) {
            File file = new File(this.imagePath);
            if (!file.exists() || file.isDirectory()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
            }
            if (file.length() > (long)QImageGlobalConfig.getMaxFaceRecognizeImageSize()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_TOO_LARGE);
            }
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getTag() {
        return this.tag;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public Set<String> getUrlSet() {
        return this.urlSet;
    }
}

