/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.log;

import org.slf4j.Logger;

public class QLogger {
    private static boolean enableDebug = true;
    private static boolean enableInfo = true;
    private static boolean enableWarn = true;
    private static boolean enableError = true;

    private QLogger() {
    }

    public static void disableDebug() {
        enableDebug = false;
    }

    public static void enableDebug() {
        enableDebug = true;
        enableInfo = true;
        enableWarn = true;
        enableError = true;
    }

    public static void disableInfo() {
        enableInfo = false;
    }

    public static void enableInfo() {
        enableInfo = true;
        enableWarn = true;
        enableError = true;
    }

    public static void disableWarn() {
        enableWarn = false;
    }

    public static void enableWarn() {
        enableWarn = true;
        enableError = true;
    }

    public static void disableError() {
        enableError = false;
    }

    public static void enableError() {
        enableError = true;
    }

    public static void reset() {
        QLogger.enableDebug();
    }

    public static void debugForLong(Logger logger, String message) {
        if (enableDebug && enableInfo && enableWarn && enableError) {
            message = message.trim();
            int maxLength = 500;
            for (int index = 0; index < message.length(); index += maxLength) {
                String sub = message.length() <= index + maxLength ? message.substring(index) : message.substring(index, maxLength + index);
                QLogger.debug(logger, sub.trim());
            }
        }
    }

    public static void debug(Logger logger, String message) {
        if (enableDebug && enableInfo && enableWarn && enableError) {
            logger.debug(message);
        }
    }

    public static void debug(Logger logger, String message, Object ... objects) {
        if (enableDebug && enableInfo && enableWarn && enableError) {
            logger.debug(message, objects);
        }
    }

    public static void info(Logger logger, String message) {
        if (enableInfo && enableWarn && enableError) {
            logger.info(message);
        }
    }

    public static void info(Logger logger, String message, Object ... objects) {
        if (enableInfo && enableWarn && enableError) {
            logger.info(message, objects);
        }
    }

    public static void warn(Logger logger, String message) {
        if (enableWarn && enableError) {
            logger.warn(message);
        }
    }

    public static void warn(Logger logger, String message, Object ... objects) {
        if (enableWarn && enableError) {
            logger.warn(message, objects);
        }
    }

    public static void error(Logger logger, String message) {
        if (enableError) {
            logger.error(message);
        }
    }

    public static void error(Logger logger, String message, Object ... objects) {
        if (enableError) {
            logger.error(message, objects);
        }
    }
}

