/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.auth;

import java.util.Locale;
import java.util.Random;

public abstract class AbsCredentialProvider {
    protected String secretId;

    public AbsCredentialProvider(String secretId) {
        this.secretId = secretId;
    }

    protected abstract String encrypt(String var1);

    private String getQImageOriginalSign(String appid, String bucket, long duration) {
        long currentTime = System.currentTimeMillis();
        long expireTime = currentTime + duration * 1000L;
        long rand = Math.abs(new Random(System.currentTimeMillis()).nextInt());
        return String.format(Locale.US, "a=%s&b=%s&k=%s&t=%d&e=%d&r=%d&u=&f=", appid, bucket, this.secretId, currentTime / 1000L, expireTime / 1000L, rand %= 10000L);
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getDurationSign(String appid, String bucket, long duration) {
        return this.encrypt(this.getQImageOriginalSign(appid, bucket, duration));
    }
}

