/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.task.tasks;

import com.tencent.qcloud.image.auth.AbsCredentialProvider;
import com.tencent.qcloud.image.log.QLogger;
import com.tencent.qcloud.image.net.NetworkStateListener;
import com.tencent.qcloud.image.net.NetworkTask;
import com.tencent.qcloud.image.net.RequestMessage;
import com.tencent.qcloud.image.net.exception.NetworkException;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ServerException;
import com.tencent.qcloud.image.services.exception.ServerExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import com.tencent.qcloud.image.services.model.QImageResult;
import com.tencent.qcloud.image.services.task.TaskLifecycleListener;
import com.tencent.qcloud.image.services.task.parser.consts.ServerUrl;
import com.tencent.qcloud.image.services.task.parser.model.RequestParser;
import com.tencent.qcloud.image.services.task.parser.model.ResponseParser;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsTask<T1 extends QImageRequest, T2 extends QImageResult> {
    private final Logger logger = LoggerFactory.getLogger(AbsTask.class);
    protected final String appid;
    protected final AbsCredentialProvider credentialProvider;
    protected final T1 request;
    protected TaskLifecycleListener<AbsTask> taskLifecycleListener;
    protected NetworkTask networkTask;
    protected NetworkStateListener networkStateListener;
    protected final String taskId;
    protected FaceIdTaskState faceIdTaskState;
    protected boolean isHttps;

    AbsTask(String appid, T1 request, AbsCredentialProvider credentialProvider) {
        this.appid = appid;
        this.request = request;
        this.taskId = String.valueOf(((QImageRequest)request).getRequestId());
        this.faceIdTaskState = FaceIdTaskState.WAITING;
        this.credentialProvider = credentialProvider;
        this.init();
    }

    public String getTaskId() {
        return this.taskId;
    }

    protected void handleOnSend() {
        QLogger.info(this.logger, "task id = {} is on send", this.taskId);
        this.faceIdTaskState = FaceIdTaskState.SENDING;
    }

    protected void handleOnResponse(Response response) {
        QLogger.info(this.logger, "task id = {} is on response", this.taskId);
        this.taskLifecycleListener.onSuccess(this);
        this.faceIdTaskState = FaceIdTaskState.SUCCEED;
    }

    protected void handleOnRetry(int retryTimes) {
        QLogger.info(this.logger, "task id = {} is on retry", this.taskId);
    }

    protected void handleOnHttpFail(int code, String message) {
        QLogger.info(this.logger, "task id = {} is on http fail", this.taskId);
    }

    protected void handleOnFail(NetworkException networkException) {
        QLogger.info(this.logger, "task id = {} is on fail", this.taskId);
        this.taskLifecycleListener.onFail(this);
        this.faceIdTaskState = FaceIdTaskState.FAILED;
    }

    protected void handleOnCancel(boolean isSuccess) {
        QLogger.info(this.logger, "task id = {} is on cancel", this.taskId);
        if (isSuccess) {
            this.faceIdTaskState = FaceIdTaskState.CANCEL;
        }
    }

    private void init() {
        this.networkStateListener = new NetworkStateListener(){

            @Override
            public void onSend(RequestMessage requestMessage) {
                AbsTask.this.handleOnSend();
            }

            @Override
            public void onResponse(RequestMessage requestMessage, Response response) {
                AbsTask.this.handleOnResponse(response);
            }

            @Override
            public void onRetry(RequestMessage requestMessage, int retryTimes) {
                AbsTask.this.handleOnRetry(retryTimes);
            }

            @Override
            public void onHttpFail(RequestMessage requestMessage, int code, String message) {
                AbsTask.this.handleOnHttpFail(code, message);
            }

            @Override
            public void onFail(RequestMessage requestMessage, NetworkException networkException) {
                AbsTask.this.handleOnFail(networkException);
            }

            @Override
            public void onCancel(RequestMessage requestMessage, boolean isSuccess) {
                AbsTask.this.handleOnCancel(isSuccess);
            }
        };
    }

    protected String getSign() {
        String sign = ((QImageRequest)this.request).getSign();
        if (sign == null && this.credentialProvider != null) {
            sign = this.credentialProvider.getDurationSign(this.appid, ((QImageRequest)this.request).getBucket(), 86400L);
        }
        return sign;
    }

    protected RequestMessage parseQImageRequest() throws ClientException {
        String protocol = this.isHttps() ? "https://" : "http://";
        String serverUrl = protocol + ServerUrl.getServerHost() + this.getServerFlag();
        HashMap<String, String> extraPara = new HashMap<String, String>();
        String sign = this.getSign();
        extraPara.put("appid", this.appid);
        extraPara.put("server_url", serverUrl);
        extraPara.put("Authorization", sign);
        return this.getRequestParser().parse(this.request, extraPara);
    }

    abstract String getServerFlag();

    abstract RequestParser<T1> getRequestParser();

    abstract ResponseParser<T2> getResponseParser();

    public boolean isHttps() {
        return this.isHttps;
    }

    public void setHttps(boolean https) {
        this.isHttps = https;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T2 start(ExecutorService executorService, OkHttpClient okHttpClient, TaskLifecycleListener<AbsTask> taskLifecycleListener) throws ClientException, ServerException {
        this.faceIdTaskState = FaceIdTaskState.WAITING;
        this.taskLifecycleListener = taskLifecycleListener;
        RequestMessage requestMessage = this.parseQImageRequest();
        this.networkTask = new NetworkTask(executorService, okHttpClient, requestMessage);
        this.taskLifecycleListener.onSend(this);
        Response response = null;
        T2 result = null;
        ServerException serverException = null;
        try {
            response = this.networkTask.start(this.networkStateListener);
            result = this.getResponseParser().parse(response);
        }
        catch (NetworkException e) {
            serverException = new ServerException(ServerExceptionType.SERVER_CONNECT_FAILED);
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
        if (serverException != null) {
            throw serverException;
        }
        return result;
    }

    public boolean cancel() {
        this.taskLifecycleListener.onCancel(this);
        return this.networkTask.cancel();
    }

    public FaceIdTaskState getFaceIdTaskState() {
        return this.faceIdTaskState;
    }

    public static enum FaceIdTaskState {
        WAITING(0, "waiting"),
        SENDING(1, "sending"),
        SUCCEED(2, "succeed"),
        CANCEL(3, "cancel"),
        FAILED(4, "failed");

        private final int code;
        private final String desc;

        private FaceIdTaskState(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

