/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.task;

import android.content.Context;
import com.tencent.qcloud.image.auth.AbsCredentialProvider;
import com.tencent.qcloud.image.log.QLogger;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ServerException;
import com.tencent.qcloud.image.services.model.QImageResult;
import com.tencent.qcloud.image.services.task.TaskConfig;
import com.tencent.qcloud.image.services.task.TaskLifecycleListener;
import com.tencent.qcloud.image.services.task.parser.consts.ServerUrl;
import com.tencent.qcloud.image.services.task.tasks.AbsTask;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskManager {
    private static final Logger logger = LoggerFactory.getLogger(TaskManager.class);
    private final Map<String, AbsTask> tasks;
    private final ExecutorService taskExecutors;
    private final int maxTaskConcurrentNumber;
    private OkHttpClient okHttpClient;
    private final String appid;
    private final AbsCredentialProvider credentialProvider;
    private final TaskLifecycleListener<AbsTask> taskLifecycleListener;
    private final Context context;
    private final TaskConfig taskConfig;

    public TaskManager(Context context, String appid, AbsCredentialProvider credentialProvider, TaskConfig taskConfig) {
        this.context = context;
        this.appid = appid;
        this.maxTaskConcurrentNumber = taskConfig.getMaxConcurrentTaskNumber();
        this.taskExecutors = Executors.newFixedThreadPool(this.maxTaskConcurrentNumber);
        this.credentialProvider = credentialProvider;
        this.tasks = new ConcurrentHashMap<String, AbsTask>();
        this.taskLifecycleListener = this.getTaskLifecycleListener();
        this.taskConfig = taskConfig;
        this.okHttpClient = this.getOkHttpClient();
    }

    private TaskLifecycleListener<AbsTask> getTaskLifecycleListener() {
        return new TaskLifecycleListener<AbsTask>(){

            @Override
            public void onSend(AbsTask task) {
            }

            @Override
            public void onSuccess(AbsTask task) {
                TaskManager.this.tasks.remove(task.getTaskId());
            }

            @Override
            public void onFail(AbsTask task) {
                TaskManager.this.tasks.remove(task.getTaskId());
            }

            @Override
            public void onCancel(AbsTask task) {
                TaskManager.this.tasks.remove(task.getTaskId());
            }
        };
    }

    private OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).retryOnConnectionFailure(false).cache(null).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return HttpsURLConnection.getDefaultHostnameVerifier().verify(ServerUrl.getServerHost(), session);
                }
            });
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(this.maxTaskConcurrentNumber);
            builder.connectTimeout((long)this.taskConfig.getHttpConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)this.taskConfig.getHttpReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)this.taskConfig.getHttpWriteTimeout(), TimeUnit.MILLISECONDS).dispatcher(dispatcher);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    public QImageResult sendTask(AbsTask task) throws ClientException, ServerException {
        if (this.tasks.containsKey(task.getTaskId())) {
            QLogger.info(logger, "the task has exist.");
            return null;
        }
        task.setHttps(this.taskConfig.isHttps());
        this.tasks.put(task.getTaskId(), task);
        QLogger.info(logger, "a task has been submit, task id = {}", task.getTaskId());
        return task.start(this.taskExecutors, this.okHttpClient, this.taskLifecycleListener);
    }

    public boolean cancelTask(int requestId) {
        String taskId = String.valueOf(requestId);
        AbsTask task = this.tasks.get(taskId);
        if (task == null) {
            QLogger.warn(logger, "the task is not exist.");
            return false;
        }
        boolean res = task.cancel();
        if (res) {
            QLogger.info(logger, "a task has been cancel, task id = {}", requestId);
        } else {
            QLogger.info(logger, "task has cancel failed");
        }
        return res;
    }

    public void release() {
        this.cancelAllTask();
        if (this.taskExecutors != null) {
            QLogger.info(logger, "task manager has been release.");
            this.taskExecutors.shutdown();
        }
    }

    public void cancelAllTask() {
        Iterator<Map.Entry<String, AbsTask>> iter = this.tasks.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next().getValue().cancel();
        }
    }
}

