/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PornDetectRequest
extends QImageRequest {
    private final String bucket;
    private Set<String> urlSet;
    private String imagePath;

    public PornDetectRequest(String bucket, String sign) {
        super(sign);
        this.bucket = bucket;
        this.urlSet = new HashSet<String>();
    }

    public PornDetectRequest(String bucket) {
        this(bucket, null);
    }

    public void addImageUrl(String imageUrl) throws ClientException {
        if (!TextUtils.isEmpty((CharSequence)this.imagePath)) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        if (this.urlSet.size() >= 20) {
            throw new ClientException(ClientExceptionType.OCR_ID_CARD_IMEGE_OR_URL_TOO_MUCH);
        }
        this.urlSet.add(imageUrl);
    }

    public void addImageUrl(Set<String> imageUrls) throws ClientException {
        if (!TextUtils.isEmpty((CharSequence)this.imagePath)) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        if (this.urlSet.size() + imageUrls.size() > 20) {
            throw new ClientException(ClientExceptionType.OCR_ID_CARD_IMEGE_OR_URL_TOO_MUCH);
        }
        this.urlSet.addAll(imageUrls);
    }

    public void setImagePath(String imagePath) throws ClientException {
        if (!this.urlSet.isEmpty()) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        this.imagePath = imagePath;
    }

    public void clearImagePath() {
        this.imagePath = null;
    }

    public void clearUrlSet() {
        if (this.urlSet != null && this.urlSet.size() > 0) {
            this.urlSet.clear();
        }
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        File file;
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (!TextUtils.isEmpty((CharSequence)this.imagePath) && this.urlSet != null && !this.urlSet.isEmpty()) {
            throw new ClientException(ClientExceptionType.NOT_SUPPORT_BOTH_URL_AND_FILE);
        }
        if ((this.urlSet == null || this.urlSet.isEmpty()) && TextUtils.isEmpty((CharSequence)this.imagePath)) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (this.urlSet != null && this.urlSet.size() > 0) {
            Iterator<String> iterator = this.urlSet.iterator();
            while (iterator.hasNext()) {
                if (!TextUtils.isEmpty((CharSequence)iterator.next())) continue;
                throw new ClientException(ClientExceptionType.IMAGE_URL_IS_NULL);
            }
        }
        if (!(TextUtils.isEmpty((CharSequence)this.imagePath) || (file = new File(this.imagePath)).exists() && !file.isDirectory())) {
            throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    public Set<String> getUrlSet() {
        return this.urlSet;
    }

    public String getImagePath() {
        return this.imagePath;
    }
}

