/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class OcrNameCardResult
extends QImageResult {
    private int code;
    private String message;
    private Map<String, NameCardResult> nameCardResults;

    public OcrNameCardResult(int httpCode, String httpMessage, int code, String message, Map<String, NameCardResult> nameCardResults) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
        this.nameCardResults = nameCardResults;
    }

    public OcrNameCardResult(int httpCode, String httpMessage, Map<String, NameCardResult> nameCardResults) {
        super(httpCode, httpMessage);
        this.nameCardResults = nameCardResults;
    }

    public OcrNameCardResult(int httpCode, String httpMessage, int code, String message) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
    }

    public String toString() {
        int resultNumber = 0;
        if (this.nameCardResults != null) {
            resultNumber = this.nameCardResults.size();
        }
        StringBuilder desc = new StringBuilder(String.format(Locale.ENGLISH, "http code = %d, http message = %s, error code = %d, error message = %s\n", this.httpCode, this.httpMessage, this.code, this.message));
        desc.append(String.format(Locale.US, "OcrNameCardResult : result number = %d\n", resultNumber));
        if (this.nameCardResults != null && !this.nameCardResults.isEmpty()) {
            Iterator<Map.Entry<String, NameCardResult>> iterator = this.nameCardResults.entrySet().iterator();
            while (iterator.hasNext()) {
                NameCardResult faceSideResult = iterator.next().getValue();
                String resultString = faceSideResult.toString();
                desc.append(resultString + "\n");
            }
        }
        return desc.toString();
    }

    public Map<String, NameCardResult> getNameCardResults() {
        return this.nameCardResults;
    }

    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    public static class NameCardResult {
        int code;
        String message;
        String key;
        String name;
        String phone;
        String uin;
        double nameConfidence;
        double phoneConfidence;
        double uinConfidence;
        String imageBase64;

        public NameCardResult(int code, String message, String key, String name, String phone, String uin, double nameConfidence, double phoneConfidence, double uinConfidence, String imageBase64) {
            this.code = code;
            this.message = message;
            this.key = key;
            this.name = name;
            this.phone = phone;
            this.uin = uin;
            this.nameConfidence = nameConfidence;
            this.phoneConfidence = phoneConfidence;
            this.uinConfidence = uinConfidence;
            this.imageBase64 = imageBase64;
        }

        public NameCardResult(int code, String message, String key) {
            this(code, message, key, null, null, null, -1.0, -1.0, -1.0, null);
        }

        public double getNameConfidence() {
            return this.nameConfidence;
        }

        public double getPhoneConfidence() {
            return this.phoneConfidence;
        }

        public double getUinConfidence() {
            return this.uinConfidence;
        }

        public String getName() {
            return this.name;
        }

        public String getPhone() {
            return this.phone;
        }

        public String getUin() {
            return this.uin;
        }

        public String getMessage() {
            return this.message;
        }

        public int getCode() {
            return this.code;
        }

        public String getKey() {
            return this.key;
        }

        public String getImageBase64() {
            return this.imageBase64;
        }

        public String toString() {
            String imageBase64Temp = TextUtils.isEmpty((CharSequence)this.imageBase64) ? "" : "XXX";
            String desc = String.format(Locale.US, "key = %s\ncode = %d, message = %s\nname = %s, phone = %s, uin = %s\nname confidence = %f, phone confidence = %f, uin confidence = %s\nimage base64 = %s", this.key, this.code, this.message, this.name, this.phone, this.uin, this.nameConfidence, this.phoneConfidence, this.uinConfidence, imageBase64Temp);
            return desc;
        }
    }
}

