/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;

public final class ImageTagDetectRequest
extends QImageRequest {
    private String bucket;
    private String imageUrl;
    private File imageFile;

    public ImageTagDetectRequest(String bucket, String imageUrl, String sign) {
        super(sign);
        this.bucket = bucket;
        this.imageUrl = imageUrl;
    }

    public ImageTagDetectRequest(String bucket, String imageUrl) {
        this(bucket, imageUrl, null);
    }

    public ImageTagDetectRequest(String bucket, File imageFile, String sign) {
        super(sign);
        this.bucket = bucket;
        this.imageFile = imageFile;
    }

    public ImageTagDetectRequest(String bucket, File imageFile) {
        this(bucket, imageFile, null);
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile == null) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile != null && (!this.imageFile.exists() || this.imageFile.isDirectory())) {
            throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }
}

