/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.QImageGlobalConfig;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.io.File;

public class FaceIdentifyRequest
extends QImageRequest {
    String bucket;
    String groupId;
    String imageUrl;
    File imageFile;

    public FaceIdentifyRequest(String bucket, String groupId, String imageUrl, String sign) {
        super(sign);
        this.bucket = bucket;
        this.groupId = groupId;
        this.imageUrl = imageUrl;
    }

    public FaceIdentifyRequest(String bucket, String groupId, String imageUrl) {
        this(bucket, groupId, imageUrl, null);
    }

    public FaceIdentifyRequest(String bucket, String groupId, File imageFile, String sign) {
        super(sign);
        this.bucket = bucket;
        this.groupId = groupId;
        this.imageFile = imageFile;
    }

    public FaceIdentifyRequest(String bucket, String groupId, File imageFile) {
        this(bucket, groupId, imageFile, null);
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.groupId)) {
            throw new ClientException(ClientExceptionType.GROUP_ID_NULL);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile == null) {
            throw new ClientException(ClientExceptionType.FILE_AND_URL_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.imageUrl) && this.imageFile != null) {
            if (!this.imageFile.exists() || this.imageFile.isDirectory()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_NOT_EXIST);
            }
            if (this.imageFile.length() > (long)QImageGlobalConfig.getMaxFaceRecognizeImageSize()) {
                throw new ClientException(ClientExceptionType.IMAGE_FILE_TOO_LARGE);
            }
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }
}

