/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FaceDeleteFaceResult
extends QImageResult {
    private int code;
    private String message;
    private String sessionId;
    private int deletedFaceNumber;
    private List<String> deletedFaceIds;

    public FaceDeleteFaceResult(int httpCode, String httpMessage, int code, String message, String sessionId, int deletedFaceNumber, List<String> deletedFaceIds) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
        this.sessionId = sessionId;
        this.deletedFaceIds = deletedFaceIds;
        this.deletedFaceNumber = deletedFaceNumber;
    }

    public FaceDeleteFaceResult(int httpCode, String httpMessage, int code, String message) {
        this(httpCode, httpMessage, code, message, null, 0, null);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getDeletedFaceNumber() {
        return this.deletedFaceNumber;
    }

    public List<String> getDeletedFaceIds() {
        return this.deletedFaceIds;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(String.format(Locale.US, "http code = %d, http message = %s\n", this.httpCode, this.httpMessage));
        if (this.code == 0) {
            desc.append(String.format(Locale.US, "code = %d, message = %s\nsession id = %s, deleted face number = %d\n", this.code, this.message, this.sessionId, this.deletedFaceNumber));
            if (this.deletedFaceIds != null && !this.deletedFaceIds.isEmpty()) {
                desc.append("deleted face id list :\n");
                Iterator<String> iterator = this.deletedFaceIds.iterator();
                while (iterator.hasNext()) {
                    desc.append(String.format(Locale.US, "  face id = %s\n", iterator.next()));
                }
            }
        } else {
            desc.append(String.format(Locale.US, "code = %d, message = %s", this.code, this.message));
        }
        return desc.toString();
    }
}

