/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import android.text.TextUtils;
import com.tencent.qcloud.image.services.exception.ClientException;
import com.tencent.qcloud.image.services.exception.ClientExceptionType;
import com.tencent.qcloud.image.services.model.QImageRequest;
import java.util.HashSet;
import java.util.Set;

public class FaceDeleteFaceRequest
extends QImageRequest {
    private String bucket;
    private String personId;
    private Set<String> faceIds;

    public FaceDeleteFaceRequest(String bucket, String personId, Set<String> faceIds, String sign) {
        super(sign);
        this.bucket = bucket;
        this.personId = personId;
        this.faceIds = new HashSet<String>(faceIds);
    }

    public FaceDeleteFaceRequest(String bucket, String personId, String faceId, String sign) {
        super(sign);
        this.bucket = bucket;
        this.personId = personId;
        this.faceIds = new HashSet<String>();
        this.faceIds.add(faceId);
    }

    public FaceDeleteFaceRequest(String bucket, String personId, Set<String> faceIds) {
        this(bucket, personId, faceIds, null);
    }

    public FaceDeleteFaceRequest(String bucket, String personId, String faceId) {
        this(bucket, personId, faceId, null);
    }

    public void addFaceId(String faceId) throws ClientException {
        if (TextUtils.isEmpty((CharSequence)faceId)) {
            throw new ClientException(ClientExceptionType.FACE_ID_IS_EMPTY);
        }
        this.faceIds.add(faceId);
    }

    @Override
    public boolean checkRequestPara() throws ClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new ClientException(ClientExceptionType.BUCKET_IS_EMPTY);
        }
        if (TextUtils.isEmpty((CharSequence)this.personId)) {
            throw new ClientException(ClientExceptionType.PERSON_ID_NULL);
        }
        if (this.faceIds == null || this.faceIds.isEmpty()) {
            throw new ClientException(ClientExceptionType.FACE_ID_IS_EMPTY);
        }
        return true;
    }

    @Override
    public String getBucket() {
        return this.bucket;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Set<String> getFaceIds() {
        return this.faceIds;
    }
}

