/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.services.model;

import com.tencent.qcloud.image.services.model.QImageResult;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FaceAddFaceResult
extends QImageResult {
    private int code;
    private String message;
    private String sessionId;
    private int addedNumber;
    private List<String> faceIds;
    private List<Integer> codes;

    public FaceAddFaceResult(int httpCode, String httpMessage, int code, String message, String sessionId, int addedNumber, List<String> faceIds, List<Integer> codes) {
        super(httpCode, httpMessage);
        this.code = code;
        this.message = message;
        this.sessionId = sessionId;
        this.addedNumber = addedNumber;
        this.faceIds = faceIds;
        this.codes = codes;
    }

    public FaceAddFaceResult(int httpCode, String httpMessage, int code, String message) {
        this(httpCode, httpMessage, code, message, null, 0, null, null);
    }

    public int getAddedNumber() {
        return this.addedNumber;
    }

    public int getCode() {
        return this.code;
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public List<String> getFaceIds() {
        return this.faceIds;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        StringBuilder desc = new StringBuilder(String.format(Locale.US, "http code = %d, http message = %s\n", this.httpCode, this.httpMessage));
        desc.append(String.format(Locale.US, "code = %d, message = %s\n", this.code, this.message));
        if (this.code == 0) {
            Iterator<Object> iterator;
            desc.append(String.format(Locale.ENGLISH, "session id = %s, added number is %d\n", this.sessionId, this.addedNumber));
            if (this.faceIds != null && !this.faceIds.isEmpty()) {
                desc.append("added face id list :\n");
                iterator = this.faceIds.iterator();
                while (iterator.hasNext()) {
                    desc.append(String.format(Locale.US, "  face id = %s\n", iterator.next()));
                }
            }
            if (this.codes != null && !this.codes.isEmpty()) {
                desc.append("added code list : \n");
                iterator = this.codes.iterator();
                while (iterator.hasNext()) {
                    desc.append(String.format(Locale.US, "  code = %d\n", iterator.next()));
                }
            }
        }
        return desc.toString();
    }
}

