/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.net.body;

import android.util.Base64OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class Base64FileRequestBody
extends RequestBody {
    File file;
    String contentType;

    public Base64FileRequestBody(File file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        long all;
        ByteArrayOutputStream base64String = new ByteArrayOutputStream();
        FileInputStream originString = new FileInputStream(this.file);
        Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)base64String, 0);
        long remain = all = this.file.length();
        int bufferSize = 2048;
        int percent = 0;
        byte[] buffer = new byte[bufferSize];
        while (remain > 0L) {
            long maxReadSize = Math.min((long)bufferSize, remain);
            int readLength = originString.read(buffer, 0, (int)maxReadSize);
            if (readLength <= 0) continue;
            base64OutputStream.write(buffer, 0, readLength);
            int progress = (int)Math.floor(100.0 * (double)(all - (remain -= (long)readLength)) / (double)all);
            if (progress < percent) continue;
            percent += 5;
        }
    }

    public long contentLength() throws IOException {
        return this.file.length();
    }
}

