/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.image.net;

import com.tencent.qcloud.image.log.QLogger;
import com.tencent.qcloud.image.net.NetworkStateListener;
import com.tencent.qcloud.image.net.RequestMessage;
import com.tencent.qcloud.image.net.exception.NetworkException;
import com.tencent.qcloud.image.net.exception.NetworkExceptionType;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTask
implements Callable<Response> {
    private final Logger logger = LoggerFactory.getLogger(NetworkTask.class);
    private final RequestMessage requestMessage;
    private final OkHttpClient okHttpClient;
    private final ExecutorService executorService;
    private Future<Response> future;
    private NetworkTaskState taskState;
    private NetworkStateListener networkStateListener;
    private Call call;
    private boolean cancelled = false;
    private int currentRetryTimes = 0;
    private final int maxRetryTimes = 2;
    private Response response;
    private NetworkException networkException;

    public NetworkTask(ExecutorService executorService, OkHttpClient okHttpClient, RequestMessage requestMessage) {
        this.executorService = executorService;
        this.okHttpClient = okHttpClient;
        this.requestMessage = requestMessage;
        this.taskState = NetworkTaskState.WAITING;
    }

    public void setNetworkStateListener(NetworkStateListener networkStateListener) {
        this.networkStateListener = networkStateListener;
    }

    public Response start(NetworkStateListener networkStateListener) throws NetworkException {
        this.future = this.executorService.submit(this);
        this.networkStateListener = networkStateListener;
        try {
            if (this.future != null) {
                this.response = this.future.get();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (CancellationException e) {
            QLogger.info(this.logger, "is task canceled.");
        }
        if (this.networkException != null) {
            throw this.networkException;
        }
        return this.response;
    }

    public boolean cancel() {
        if (this.cancelled) {
            QLogger.warn(this.logger, "the network task has been cancelled before..");
            return false;
        }
        this.cancelled = true;
        if (this.call != null) {
            this.call.cancel();
        }
        boolean isCancelled = false;
        if (this.future != null) {
            isCancelled = this.future.cancel(true);
        }
        this.handleOnCancel(isCancelled);
        if (this.future.isCancelled()) {
            QLogger.info(this.logger, "the network cancelled success..");
        } else {
            QLogger.info(this.logger, "the network cancelled failed..");
        }
        return isCancelled;
    }

    private void handleOnSend() {
        this.taskState = NetworkTaskState.SENDING;
        if (this.networkStateListener != null) {
            this.networkStateListener.onSend(this.requestMessage);
        }
    }

    private void handleOnResponse(Response result) {
        QLogger.info(this.logger, "handle on response in network task.");
        this.taskState = NetworkTaskState.SUCCEED;
        if (this.networkStateListener != null) {
            this.networkStateListener.onResponse(this.requestMessage, result);
        }
    }

    private void handleOnRetry(NetworkException networkException) {
        QLogger.debug(this.logger, "handle on retry. times = " + this.currentRetryTimes);
        if (this.taskState != NetworkTaskState.RETRY) {
            this.taskState = NetworkTaskState.RETRY;
        }
        if (this.currentRetryTimes < 2 && this.response == null) {
            ++this.currentRetryTimes;
            if (this.networkStateListener != null) {
                this.networkStateListener.onRetry(this.requestMessage, this.currentRetryTimes);
            }
            this.call();
        } else {
            this.handleOnFail(networkException);
        }
    }

    private void handleOnFail(NetworkException networkException) {
        this.taskState = NetworkTaskState.FAILED;
        if (this.networkStateListener != null) {
            this.networkStateListener.onFail(this.requestMessage, networkException);
        }
        this.networkException = networkException;
    }

    private void handleOnHttpFail(int code, String message) {
        this.taskState = NetworkTaskState.FAILED;
        if (this.networkStateListener != null) {
            this.networkStateListener.onHttpFail(this.requestMessage, code, message);
        }
    }

    private void handleOnCancel(boolean isCancelled) {
        this.taskState = NetworkTaskState.CANCEL;
        if (this.networkStateListener != null) {
            this.networkStateListener.onCancel(this.requestMessage, isCancelled);
        }
    }

    public NetworkTaskState getTaskState() {
        return this.taskState;
    }

    public RequestMessage getRequestMessage() {
        return this.requestMessage;
    }

    @Override
    public Response call() {
        Response response;
        block10: {
            if (this.taskState != NetworkTaskState.WAITING && this.taskState != NetworkTaskState.RETRY) {
                QLogger.info(this.logger, "the network task has been executed or is not retrying..");
                return null;
            }
            if (this.taskState == NetworkTaskState.WAITING) {
                this.handleOnSend();
            }
            String url = this.requestMessage.getUrl();
            QLogger.debug(this.logger, url);
            Headers headers = Headers.of(this.requestMessage.getHeaders());
            QLogger.debug(this.logger, headers.toString());
            RequestBody requestBody = this.requestMessage.getRequestBody();
            Request.Builder builder = new Request.Builder();
            Request httpRequest = builder.url(url).headers(headers).post(requestBody).build();
            QLogger.debug(this.logger, "prepare send a http request.");
            response = null;
            try {
                this.call = this.okHttpClient.newCall(httpRequest);
                response = this.call.execute();
                if (response == null) {
                    QLogger.warn(this.logger, "the server response is null.");
                    this.handleOnRetry(new NetworkException(NetworkExceptionType.SERVER_CONNECT_FAILED));
                    return null;
                }
                if (response.code() == 400 || response.code() == 401) {
                    QLogger.warn(this.logger, "http code is {}, message is {}", response.code(), response.message());
                    this.handleOnResponse(response);
                } else if (response.isSuccessful()) {
                    QLogger.info(this.logger, "http response is success..");
                    this.handleOnResponse(response);
                } else {
                    QLogger.error(this.logger, "HTTP code is error, code=" + response.code() + ", message=" + response.message());
                    this.handleOnHttpFail(response.code(), response.message());
                    if (!this.cancelled) {
                        this.handleOnRetry(new NetworkException(response.code(), response.message()));
                        return null;
                    }
                }
            }
            catch (IOException e) {
                if (this.cancelled) break block10;
                e.printStackTrace();
                QLogger.warn(this.logger, "task execute with exception, the network task is retry..");
                this.handleOnRetry(new NetworkException(NetworkExceptionType.SERVER_CONNECT_FAILED));
                return null;
            }
        }
        return response;
    }

    static enum NetworkTaskState {
        WAITING(0, "waiting"),
        SENDING(1, "sending"),
        SUCCEED(2, "succeed"),
        CANCEL(3, "cancel"),
        RETRY(4, "retry"),
        FAILED(5, "failed");

        private final int code;
        private final String desc;

        private NetworkTaskState(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

