/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.user;

import com.tencent.qcloud.facein.pass.FaceInServiceConfig;
import com.tencent.qcloud.facein.user.FaceInModelType;
import com.tencent.qcloud.facein.user.FaceInResultListener;
import com.tencent.qcloud.network.cosv4.CosV4CredentialProvider;

public class FaceInConfig {
    private static String appid;
    private static String bucket;
    private static String sign;
    private static int httpConnectTimeout;
    private static int httpSocketTimeout;
    private static boolean isHttps;
    private static int idCardPersonCompareConfidence;
    private static int lipVideoPersonCompareConfidence;
    private static int faceAliveCompareConfidence;
    private static CosV4CredentialProvider credentialProvider;
    private static boolean debug;
    public static FaceInModelType ocrModel;
    public static FaceInResultListener faceInResultListener;
    private static int faceDetectTimeout;
    private static boolean isDev;

    public static void setOcrModel(FaceInModelType ocrModel) {
        FaceInConfig.ocrModel = ocrModel;
    }

    public static FaceInModelType getOcrModel() {
        return ocrModel;
    }

    public FaceInConfig() {
        FaceInConfig.setDebug(false);
        FaceInConfig.setFaceDetectTimeout(5000);
    }

    public static void setDebug(boolean debug) {
        FaceInConfig.debug = debug;
    }

    public static void setFaceAliveCompareConfidence(int faceAliveCompareConfidence) {
        FaceInConfig.faceAliveCompareConfidence = faceAliveCompareConfidence;
    }

    public static int getFaceAliveCompareConfidence() {
        return faceAliveCompareConfidence;
    }

    public static void setIsHttps(boolean isHttps) {
        FaceInConfig.isHttps = isHttps;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setAppid(String appid) {
        FaceInConfig.appid = appid;
    }

    public static void setBucket(String bucket) {
        FaceInConfig.bucket = bucket;
    }

    public static void setSign(String sign) {
        FaceInConfig.sign = sign;
    }

    public static String getAppid() {
        return appid;
    }

    public static String getBucket() {
        return bucket;
    }

    public static CosV4CredentialProvider getCredentialProvider() {
        return credentialProvider;
    }

    public static void setCredentialProvider(CosV4CredentialProvider credentialProvider) {
        FaceInConfig.credentialProvider = credentialProvider;
    }

    public static int getHttpSocketTimeout() {
        return httpSocketTimeout;
    }

    public static void setHttpSocketTimeout(int httpSocketTimeout) {
        if (httpSocketTimeout > 500) {
            FaceInConfig.httpSocketTimeout = httpSocketTimeout;
        }
    }

    public static int getHttpConnectTimeout() {
        return httpConnectTimeout;
    }

    public static void setHttpConnectTimeout(int httpConnectTimeout) {
        if (httpConnectTimeout > 500) {
            FaceInConfig.httpConnectTimeout = httpConnectTimeout;
        }
    }

    public static void setIdCardPersonCompareConfidence(int idCardPersonCompareConfidence) {
        if (idCardPersonCompareConfidence <= 100 && idCardPersonCompareConfidence >= 0) {
            FaceInConfig.idCardPersonCompareConfidence = idCardPersonCompareConfidence;
        }
    }

    public static void setLipVideoPersonCompareConfidence(int lipVideoPersonCompareConfidence) {
        if (lipVideoPersonCompareConfidence >= 0 && lipVideoPersonCompareConfidence <= 100) {
            FaceInConfig.lipVideoPersonCompareConfidence = lipVideoPersonCompareConfidence;
        }
    }

    public static int getIdCardPersonCompareConfidence() {
        return idCardPersonCompareConfidence;
    }

    public static int getLipVideoPersonCompareConfidence() {
        return lipVideoPersonCompareConfidence;
    }

    public static FaceInResultListener getFaceInResultListener() {
        return faceInResultListener;
    }

    public static void setFaceInResultListener(FaceInResultListener faceInResultListener) {
        FaceInConfig.faceInResultListener = faceInResultListener;
    }

    private static boolean setFaceDetectTimeout(int faceDetectTimeout) {
        if (faceDetectTimeout < 2000) {
            return false;
        }
        FaceInConfig.faceDetectTimeout = faceDetectTimeout;
        return true;
    }

    public static int getFaceDetectTimeout() {
        return faceDetectTimeout;
    }

    public static boolean isDev() {
        return isDev;
    }

    public static void setIsDev(boolean isDev) {
        FaceInConfig.isDev = isDev;
    }

    public static FaceInServiceConfig getFaceInServiceConfig() {
        FaceInServiceConfig faceInServiceConfig = new FaceInServiceConfig(FaceInConfig.getAppid());
        faceInServiceConfig.setDev(isDev);
        faceInServiceConfig.setUserAgent("facein-sdk-android-1.0.1");
        faceInServiceConfig.setConnectionTimeout(httpConnectTimeout);
        faceInServiceConfig.setHttpProtocol(isHttps);
        faceInServiceConfig.setSocketTimeout(httpSocketTimeout);
        return faceInServiceConfig;
    }

    static {
        httpConnectTimeout = 20000;
        httpSocketTimeout = 20000;
        idCardPersonCompareConfidence = 70;
        lipVideoPersonCompareConfidence = 70;
        faceAliveCompareConfidence = 70;
        debug = false;
        ocrModel = FaceInModelType.OCR_ID_CARD_IMAGE_COMPARE;
        faceDetectTimeout = 5000;
        isDev = false;
    }
}

