/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.controler;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import com.tencent.qcloud.facein.common.LocalPathHelper;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import com.tencent.qcloud.facein.exception.FaceInSaasException;
import com.tencent.qcloud.facein.exception.FaceInSaasExceptionType;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudVideoCamera;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.IdCardCompareRequest;
import com.tencent.qcloud.facein.pass.model.IdCardCompareResult;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.youtulivecheck.YoutuLiveCheck;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceAliveDetectThread
implements Runnable,
Camera.PreviewCallback {
    private Logger logger = LoggerFactory.getLogger(FaceAliveDetectThread.class);
    private QCloudVideoCamera videoCamera;
    private final QCloudCameraPreview preview;
    private byte[] frameData = null;
    private YoutuLiveCheck.FaceStatus faceStatus;
    private YoutuLiveCheck liveCheck;
    private final FaceInService saasService;
    private boolean hasDetectFace;
    private boolean hasDetectedHeadShake;
    private boolean hasDetectedWink;
    private volatile boolean stopped;
    private FaceAliveDetectListener detectListener;
    private Handler mainHandler;
    private String videoPath;
    private int rotation;
    private Context context;
    private long detectFrameCount;
    private CountDownLatch blocker;
    private Timer timer;
    Bitmap image;

    public FaceAliveDetectThread(Context context, FaceInService saasService, QCloudCameraPreview preview, int rotation, Handler handler) {
        this.context = context;
        this.saasService = saasService;
        this.preview = preview;
        this.rotation = rotation;
        this.mainHandler = handler;
        this.stopped = false;
        this.hasDetectFace = false;
    }

    public void setDetectListener(FaceAliveDetectListener detectListener) {
        this.detectListener = detectListener;
    }

    public void start() {
        this.stopped = false;
        this.hasDetectFace = false;
        new Thread(this).start();
    }

    public void stop() {
        this.stopped = true;
        this.unlock();
        this.saasService.cancelAll();
    }

    @Override
    public void run() {
        this.liveCheck = YoutuLiveCheck.getInstance();
        this.liveCheck.init(this.context, "huotidetect_CloudImage.licence", 0, true);
        this.initModel();
        this.liveCheck.DoDetectionInit();
        this.videoCamera = new QCloudVideoCamera(this.rotation, 1);
        this.videoCamera.setFocusMode("continuous-picture");
        if (this.videoCamera.prepare(this.preview) && this.videoCamera.setPreviewCallback(this) && this.videoCamera.start()) {
            QCloudLogger.info((Logger)this.logger, (String)"camera prepare success");
            QCloudLogger.info((Logger)this.logger, (String)"start face detect.");
            this.StartDetection();
            QCloudLogger.debug((Logger)this.logger, (String)"waiting for face.");
            this.lock();
            if (!this.stopped) {
                QCloudLogger.error((Logger)this.logger, (String)"has detect head shake.");
                if (this.detectListener != null) {
                    this.detectListener.onHeadShake(this);
                }
                this.lock();
                if (!this.stopped) {
                    File file;
                    QCloudLogger.error((Logger)this.logger, (String)"has detect wink.");
                    if (this.detectListener != null) {
                        this.detectListener.onWink(this);
                    }
                    if ((file = this.stopAliveDetect()) != null) {
                        IdCardCompareRequest idCardCompareRequest = new IdCardCompareRequest(FaceInConfig.getBucket(), UserIdCardInfo.name, UserIdCardInfo.id, file.getAbsolutePath());
                        IdCardCompareResult idCardCompareResult = null;
                        try {
                            idCardCompareResult = this.saasService.idCardCompare(idCardCompareRequest);
                        }
                        catch (QCloudException e) {
                            e.printStackTrace();
                        }
                        if (idCardCompareResult != null && idCardCompareResult.isSuccess(FaceInConfig.getFaceAliveCompareConfidence())) {
                            this.detectListener.onSuccess(this, idCardCompareResult);
                            QCloudLogger.debug((Logger)this.logger, (String)"recognize success");
                        } else {
                            this.detectListener.onFailed(this, new FaceInSaasException(FaceInSaasExceptionType.FACE_ALIVE_RECOGNIZE_FAILED));
                            QCloudLogger.debug((Logger)this.logger, (String)"recognize failed");
                        }
                    } else {
                        this.detectListener.onFailed(this, new FaceInSaasException(FaceInSaasExceptionType.FACE_ALIVE_CATCH_IMAGE_FAILED));
                        QCloudLogger.debug((Logger)this.logger, (String)"file is null");
                    }
                }
            }
        } else {
            QCloudLogger.info((Logger)this.logger, (String)"Camera prepare failed");
        }
        QCloudLogger.info((Logger)this.logger, (String)"take photo finished");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.videoCamera.setPreviewCallback(null);
        this.videoCamera.stop();
        this.videoCamera.release();
    }

    private void lock() {
        if (this.blocker == null || this.blocker.getCount() <= 0L) {
            this.blocker = new CountDownLatch(1);
        }
        try {
            this.blocker.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(long times) {
        if (this.blocker == null || this.blocker.getCount() <= 0L) {
            this.blocker = new CountDownLatch(1);
        }
        try {
            this.blocker.await(times, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.blocker.countDown();
        }
    }

    private void unlock() {
        if (this.blocker != null && this.blocker.getCount() > 0L) {
            this.blocker.countDown();
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.frameData = data;
    }

    private int StartDetection() {
        int startStatus = this.liveCheck.DoDetectionInit();
        this.timer = new Timer();
        long delayTime = 1000L;
        long periodTime = 70L;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Camera.Size previewSize = FaceAliveDetectThread.this.videoCamera.getPreviewSize();
                int imageWidth = previewSize.width;
                int imageHeight = previewSize.height;
                FaceAliveDetectThread.this.detectFrameCount++;
                if (FaceAliveDetectThread.this.frameData != null) {
                    FaceAliveDetectThread.this.faceStatus = FaceAliveDetectThread.this.liveCheck.DoDetectionProcess(FaceAliveDetectThread.this.frameData, imageWidth, imageHeight);
                    if (FaceAliveDetectThread.this.liveCheck.GetResultImage() != null) {
                        FaceAliveDetectThread.this.image = FaceAliveDetectThread.this.liveCheck.GetResultImage();
                    }
                    if (FaceAliveDetectThread.this.faceStatus != null) {
                        QCloudLogger.debug((Logger)FaceAliveDetectThread.this.logger, (String)"has detected face");
                        if (!FaceAliveDetectThread.this.hasDetectedHeadShake) {
                            if (((FaceAliveDetectThread)FaceAliveDetectThread.this).faceStatus.liveness_head == 1) {
                                QCloudLogger.debug((Logger)FaceAliveDetectThread.this.logger, (String)"has detected head shake");
                                FaceAliveDetectThread.this.hasDetectedHeadShake = true;
                                FaceAliveDetectThread.this.detectFrameCount = 0L;
                                FaceAliveDetectThread.this.unlock();
                            }
                        } else if (!FaceAliveDetectThread.this.hasDetectedWink) {
                            if (((FaceAliveDetectThread)FaceAliveDetectThread.this).faceStatus.liveness_eye == 1) {
                                if (FaceAliveDetectThread.this.image == null) {
                                    QCloudLogger.error((Logger)FaceAliveDetectThread.this.logger, (String)"has detect wink, but image is null");
                                    FaceAliveDetectThread.this.detectListener.onNullResultImage(FaceAliveDetectThread.this);
                                    FaceAliveDetectThread.this.detectFrameCount = 0L;
                                    return;
                                }
                                QCloudLogger.debug((Logger)FaceAliveDetectThread.this.logger, (String)"has detected wink");
                                FaceAliveDetectThread.this.hasDetectedWink = true;
                                FaceAliveDetectThread.this.detectFrameCount = 0L;
                                FaceAliveDetectThread.this.unlock();
                            }
                        } else {
                            FaceAliveDetectThread.this.timer.cancel();
                            FaceAliveDetectThread.this.videoCamera.setPreviewCallback(null);
                        }
                    }
                }
                if (FaceAliveDetectThread.this.detectFrameCount > 80L) {
                    if (!FaceAliveDetectThread.this.hasDetectedHeadShake) {
                        FaceAliveDetectThread.this.detectListener.onDetectHeadShakeTimeout(FaceAliveDetectThread.this);
                    } else {
                        FaceAliveDetectThread.this.detectListener.onDetectWinkTimeout(FaceAliveDetectThread.this);
                    }
                    FaceAliveDetectThread.this.detectFrameCount = 0L;
                }
            }
        }, delayTime, periodTime);
        return startStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File stopAliveDetect() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.liveCheck.GetResultImage() != null) {
            this.image = this.liveCheck.GetResultImage();
        }
        File file = null;
        if (this.image != null) {
            file = new File(LocalPathHelper.getLocalImagePath(), "alive.jpg");
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                this.image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            QCloudLogger.debug((Logger)this.logger, (String)"the image is null");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModel() {
        byte[] ufdmtccbin = null;
        byte[] ufatbin = null;
        InputStream fudmInputStream = null;
        InputStream ufatInputStream = null;
        try {
            fudmInputStream = this.context.getAssets().open("ufdmtcc.bin");
            int available = fudmInputStream.available();
            ufdmtccbin = new byte[available];
            fudmInputStream.read(ufdmtccbin);
            ufatInputStream = this.context.getAssets().open("ufat.bin");
            available = ufatInputStream.available();
            ufatbin = new byte[available];
            ufatInputStream.read(ufatbin);
            this.liveCheck.Init(ufdmtccbin, ufatbin);
        }
        catch (IOException e) {
            Log.e((String)"LiveCheck", (String)"initModel error");
        }
        finally {
            if (fudmInputStream != null) {
                try {
                    fudmInputStream.close();
                    ufatInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface FaceAliveDetectListener {
        public void onHeadShake(FaceAliveDetectThread var1);

        public void onDetectHeadShakeTimeout(FaceAliveDetectThread var1);

        public void onWink(FaceAliveDetectThread var1);

        public void onDetectWinkTimeout(FaceAliveDetectThread var1);

        public void onNullResultImage(FaceAliveDetectThread var1);

        public void onSuccess(FaceAliveDetectThread var1, IdCardCompareResult var2);

        public void onFailed(FaceAliveDetectThread var1, FaceInSaasException var2);
    }
}

