/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.activity.LipVideoCompareEntryActivity;
import com.tencent.qcloud.facein.activity.LipVideoCompareFailedActivity;
import com.tencent.qcloud.facein.activity.LipVideoCompareSuccessActivity;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import com.tencent.qcloud.facein.controler.OcrLipDetectThread;
import com.tencent.qcloud.facein.dialog.FaceInDialogs;
import com.tencent.qcloud.facein.exception.FaceInSaasException;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.VideoRecognizeResult;
import com.tencent.qcloud.facein.ui.NumberMarqueeMaskView;
import com.tencent.qcloud.facein.ui.OcrLipDetectTopView;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.facein.user.FaceInFailedType;
import com.tencent.qcloud.facein.user.FaceInModelType;
import com.tencent.qcloud.facein.user.FaceInResultListener;
import com.tencent.qcloud.facein.user.IdCardInfo;
import com.tencent.qcloud.network.logger.QCloudLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LipVideoCompareActivity
extends Activity {
    private Logger logger = LoggerFactory.getLogger(LipVideoCompareActivity.class);
    private QCloudCameraPreview preview;
    private SensorManager sensorManager;
    private OcrLipDetectTopView topView;
    private OcrLipDetectThread detectThread;
    private FaceInService saasService;
    private Dialog progressDialog;
    private Handler mainHandler;
    private TextView back;
    private int rotation;
    OcrLipDetectThread.OcrLipDetectListener ocrLipDetectListener = new OcrLipDetectThread.OcrLipDetectListener(){

        @Override
        public void onDetectFaceTimeout(OcrLipDetectThread detectThread) {
            LipVideoCompareActivity.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)LipVideoCompareActivity.this, (CharSequence)LipVideoCompareActivity.this.getResources().getString(R.string.do_not_detect_face), (int)0).show();
                }
            });
        }

        @Override
        public void onDetectFace(OcrLipDetectThread detectThread) {
            QCloudLogger.info((Logger)LipVideoCompareActivity.this.logger, (String)"on face detect.");
            LipVideoCompareActivity.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    LipVideoCompareActivity.this.topView.getTipView().setText((CharSequence)LipVideoCompareActivity.this.getResources().getString(R.string.please_read_number_by_step));
                }
            });
        }

        @Override
        public void onGetLip(OcrLipDetectThread detectThread, final String lip) {
            QCloudLogger.info((Logger)LipVideoCompareActivity.this.logger, (String)"on get lip");
            LipVideoCompareActivity.this.topView.startNumberMarqueeMaskView(Integer.parseInt(lip), LipVideoCompareActivity.this.mainHandler, new NumberMarqueeMaskView.MarqueeFinishListener(){

                @Override
                public void onFinish(NumberMarqueeMaskView numberMarquee, int number) {
                    if (number == 3) {
                        LipVideoCompareActivity.this.topView.startNumberMarquee(Integer.parseInt(lip), 1000, LipVideoCompareActivity.this.mainHandler);
                        LipVideoCompareActivity.this.mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                LipVideoCompareActivity.this.topView.setBackgroundColor(Color.argb((int)0, (int)100, (int)100, (int)100));
                            }
                        });
                    }
                }
            });
            LipVideoCompareActivity.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    LipVideoCompareActivity.this.topView.setBackgroundColor(Color.argb((int)100, (int)100, (int)100, (int)100));
                    LipVideoCompareActivity.this.topView.changePattern();
                }
            });
        }

        @Override
        public void onFinishRecord(OcrLipDetectThread detectThread) {
            QCloudLogger.info((Logger)LipVideoCompareActivity.this.logger, (String)"On finish record");
            LipVideoCompareActivity.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    LipVideoCompareActivity.this.progressDialog = FaceInDialogs.simpleProgressDialog((Context)LipVideoCompareActivity.this);
                }
            });
        }

        @Override
        public void onSuccess(OcrLipDetectThread detectThread, VideoRecognizeResult result) {
            QCloudLogger.info((Logger)LipVideoCompareActivity.this.logger, (String)"On success");
            LipVideoCompareActivity.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (LipVideoCompareActivity.this.progressDialog != null) {
                        LipVideoCompareActivity.this.progressDialog.dismiss();
                    }
                }
            });
            float similarity = 0.0f;
            if (result != null && result.getVideoIdCardCompareMessage() != null) {
                similarity = result.getVideoIdCardCompareMessage().getSimilarity();
            }
            LipVideoCompareActivity.this.sendSuccessMessage(similarity);
            Intent intent = new Intent((Context)LipVideoCompareActivity.this, LipVideoCompareSuccessActivity.class);
            LipVideoCompareActivity.this.startActivity(intent);
            LipVideoCompareActivity.this.finish();
        }

        @Override
        public void onFailed(OcrLipDetectThread detectThread, FaceInSaasException code) {
            QCloudLogger.info((Logger)LipVideoCompareActivity.this.logger, (String)"On failed");
            LipVideoCompareActivity.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (LipVideoCompareActivity.this.progressDialog != null) {
                        LipVideoCompareActivity.this.progressDialog.dismiss();
                    }
                }
            });
            LipVideoCompareActivity.this.sendFailedMessage();
            Intent intent = new Intent((Context)LipVideoCompareActivity.this, LipVideoCompareFailedActivity.class);
            LipVideoCompareActivity.this.startActivity(intent);
            LipVideoCompareActivity.this.finish();
        }
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_lip_video_compare);
        this.rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        this.sensorManager = (SensorManager)this.getSystemService("sensor");
        this.mainHandler = new Handler(this.getMainLooper());
        this.topView = (OcrLipDetectTopView)this.findViewById(R.id.top_view);
        this.preview = (QCloudCameraPreview)this.findViewById(R.id.preview);
        this.back = (TextView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LipVideoCompareActivity.this.onBack();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.topView.getTipView().setVisibility(0);
        this.saasService = new FaceInService((Context)this, FaceInConfig.getFaceInServiceConfig(), FaceInConfig.getCredentialProvider());
        this.detectThread = new OcrLipDetectThread((Context)this, this.sensorManager, this.saasService, this.preview, this.rotation, this.mainHandler);
        this.detectThread.setDetectListener(this.ocrLipDetectListener);
        this.detectThread.start();
    }

    protected void onPause() {
        super.onPause();
        this.detectThread.stop();
        this.saasService.release();
    }

    private void onBack() {
        Intent intent = new Intent((Context)this, LipVideoCompareEntryActivity.class);
        this.startActivity(intent);
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.onBack();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void sendSuccessMessage(float similarity) {
        final FaceInResultListener resultListener = FaceInConfig.getFaceInResultListener();
        if (resultListener != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IdCardInfo idCardInfo = new IdCardInfo(UserIdCardInfo.name, UserIdCardInfo.id, UserIdCardInfo.addr, UserIdCardInfo.authority, UserIdCardInfo.date);
                    resultListener.onSuccess(FaceInModelType.OCR_ID_CARD_LIP_VIDEO_COMPARE, idCardInfo);
                }
            }).start();
        }
    }

    private void sendFailedMessage() {
        final FaceInResultListener resultListener = FaceInConfig.getFaceInResultListener();
        if (resultListener != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    resultListener.onFailed(FaceInModelType.OCR_ID_CARD_LIP_VIDEO_COMPARE, FaceInFailedType.FACE_IN_SIMILARITY_LOW);
                }
            }).start();
        }
    }
}

